//
//	Floopy IStorageDevice Server
//

#include <pekoe.h>
#include <string.h>
#include <IStorageDevice.h>

class FDDriver : public IStorageDevice {

public:
	int open();
	int close();
	int read(size_t lba, void* buf, int size);
	int write(size_t lba, void* buf, int size);
	int ioctl(void* p);

private:
	volume_info	vi;
	int	lasterror;
};

const	int device_floppy=0x40000000;

IStorageDevice* getFloppy(void){
	return (IStorageDevice*)new FDDriver();
}

int FDDriver::open(){
	if(lasterror=sys_fs_open(device_floppy,0)){
		return false;
	}else{
		lasterror=sys_fs_ioctl(device_floppy,ioctl_get_information,sizeof(vi),&vi);
		return true;
	}
}

int FDDriver::close(){
	return (lasterror=sys_fs_close(device_floppy,0))?false:true;
}

int FDDriver::read(size_t lba,void* buf,int size){
	return (lasterror=sys_fs_read(device_floppy,0,lba,buf,(size+vi.BytesParSector-1)/vi.BytesParSector))?false:true;
}

int FDDriver::write(size_t lba,void* buf,int size){
	return (lasterror=sys_fs_write(device_floppy,0,lba,buf,(size+vi.BytesParSector-1)/vi.BytesParSector))?false:true;
}

//	ioctl is unknown
int FDDriver::ioctl(void* p){
	return false;
}
