//
// グラフィックスハロー
// this file is encoded in utf-8
//

#include <pekoe.h>
#include <stdio.h>
#include <sys/gbc.h>

inline void pset(int x,int y){ sys_gs_draw_pixel(x,y); }

#if 0
void circle(int x0,int y0,int r){
  int x, y, f;
  x = r;
  y = 0;
  f = -2 * r + 3;

  while (x >= y)
  {
    pset(x0 + x, y0 + y);
    pset(x0 - x, y0 + y);
    pset(x0 + y, y0 + x);
    pset(x0 - y, y0 + x);
    pset(x0 - x, y0 - y);
    pset(x0 - y, y0 - x);
    pset(x0 + y, y0 - x);
    pset(x0 + x, y0 - y);
    if (f >= 0)
    {
      x--;
      f -= 4 * x;
    }
    y ++;
    f += 4 * y + 2;
  }
}

void fillCircle(int x0,int y0,int r){
  int i;
  int x, y;
  x = r;
  y = 0;
  int f = -2 * r + 3;

  while(x >= y)
  {
    for (i = x0 - x; i <= x0 + x; i ++)
    {
      pset(i, y0 + y);
      pset(i, y0 - y);
    }
    for (i = x0 - y; i <= x0 + y; i ++)
    {
      pset(i, y0 - x);
      pset(i, y0 + x);
    }
    if (f >= 0)
    {
      x--;
      f -= 4 * x;
    }
    y ++;
    f += 4 * y + 2;
  }
}
#endif

byte bitmap[16][16] = {
	{0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x10,0x0F,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x10,0x07,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x10,0x07,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x10,0x07,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x0F,0x10,0x00,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x0F,0x10,0x10,0x0F,0x0F,0x0F,0x0F,0x10,0x10,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x10,0x07,0x0f,0x10,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00,0x00},
	{0x00,0x00,0x10,0x10,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x10,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x10,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x10,0x10,0x00},
	{0x00,0x00,0x00,0x10,0x07,0x07,0x07,0x07,0x07,0x07,0x10,0x10,0x10,0x10,0x10,0x00},
	{0x00,0x00,0x00,0x00,0x10,0x10,0x07,0x07,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
};

uint32 bitmap32[16][16] = {
	{0x11000000,0x11000000,0x11000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x11000000,0x00FFFFFF,0x00FFFFFF,0x11000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x11000000,0x00777777,0x00FFFFFF,0x11000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x00000000,0x11000000,0x00777777,0x00FFFFFF,0x11000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x00000000,0x11000000,0x00777777,0x00FFFFFF,0x11000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x00000000,0x00000000,0x11000000,0x00777777,0x00FFFFFF,0x11000000,0x00000000,0x11000000,0x11000000,0x11000000,0x11000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x00000000,0x00000000,0x11000000,0x00777777,0x00FFFFFF,0x11000000,0x11000000,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x11000000,0x11000000,0x00000000,0x00000000,0x00000000},
	{0x00000000,0x00000000,0x00000000,0x11000000,0x00777777,0x00ffffff,0x11000000,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x11000000,0x00000000,0x00000000,0x00000000},
	{0x00000000,0x00000000,0x11000000,0x11000000,0x00777777,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x11000000,0x00000000,0x00000000},
	{0x00000000,0x00000000,0x11000000,0x00777777,0x11000000,0x00777777,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x11000000,0x00000000,0x00000000},
	{0x00000000,0x00000000,0x11000000,0x00777777,0x11000000,0x00777777,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x11000000,0x00000000,0x00000000},
	{0x00000000,0x00000000,0x11000000,0x00777777,0x00777777,0x00777777,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x00FFFFFF,0x11000000,0x11000000,0x11000000,0x00000000},
	{0x00000000,0x00000000,0x00000000,0x11000000,0x00777777,0x00777777,0x00777777,0x00777777,0x00777777,0x00777777,0x11000000,0x11000000,0x11000000,0x11000000,0x11000000,0x00000000},
	{0x00000000,0x00000000,0x00000000,0x00000000,0x11000000,0x11000000,0x00777777,0x00777777,0x11000000,0x11000000,0x11000000,0x11000000,0x11000000,0x00000000,0x00000000,0x00000000},
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x11000000,0x11000000,0x11000000,0x11000000,0x11000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x11000000,0x11000000,0x11000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
};


byte monobitmap[16*2] = {
	0xE0,0x00,
	0x90,0x00,
	0x90,0x00,
	0x48,0x00,
	0x48,0x00,
	0x25,0xE0,
	0x26,0x18,
	0x12,0x04,
	0x12,0x04,
	0x20,0x0E,
	0x10,0x3E,
	0x0C,0xF8,
	0x03,0xE0,
	0x03,0x80,
};

int main(void){
	GSSTATUS gs;
	sys_gs_get_status(&gs);

#if 1
	//	BLT
//	int r=gbc_blt_fast(8,0,0,16,16,bitmap);
//	if(r==-2){ puts("error: blt 8bpp is not supported for this mode."); return 0; }
	for(int i=5;i<800;i+=8){
		gbc_blt_screen(32,i,i/8,16,16,bitmap32);
		gbc_blt_screen(32,i/8,i,16,16,bitmap32);
		gbc_blt_screen(8,i,i,16,16,bitmap);
	}
	return 0;
#else
	//	グラデ
	for(int i=0;i<gs.height;i++){
		uint s=i*256/gs.height;
		for(int j=0;j<gs.width;j++){
			uint c=
				((j*s/gs.width)<<16)
				|
				(((gs.width-j)*s/gs.width)<<8)
				|
				(255-s)
				;
			gbc_set_pixel_argb(j,i,c);
		}
	}
#endif

	//	円の描画
#if 0
		fillCircle(gs.width/2,gs.height/2,100);
	for(int i=0;i<5;i++){
		circle(gs.width/10*(i*2),gs.height/4,gs.width/7);
	}
#endif

	return 0;
}
