/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.phalanx.servlet;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.logical_paradox.phalanx.DocumentProcessor;

/**
 * jo[TT[rX̃tgGhT[ubg
 * XMLhLgPOSTŎMāAT[o[Ɍv𔭍sAʂXMLɕϊĖ߂܂B<br>
 * T[ubg̏p[^ƂāA̒lwł܂B<br>
 * <li><b>enable_get_method</b>:&nbsp;&nbsp;&nbsp;GETɂXMLf[^M܂B</li>
 * <li><b>dsruri</b>:&nbsp;&nbsp;&nbsp;T[o[Tۂ̋N_ƂȂAUlbg[ÑANZX|Cg(DSR)</li>
 * <li><b>encoding</b>:&nbsp;&nbsp;&nbsp;ʂ̏o̓GR[fBO</li>
 * <li><b>config.dir</b></li>:&nbsp;&nbsp;&nbsp;RtBOt@Ci[ĂfBNg(ReLXgpX)</li>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.9 $
 */
public class SearchServlet extends HttpServlet {
	/** VAo[WUID */
	private static final long serialVersionUID = 7049247806827014894L;

	public static final String KEY_ENABLE_GET_METHOD = "enable_get_method";
	public static final String KEY_DSRURI = "dsruri";
	public static final String KEY_XML_ENCODING = "encoding";
	public static final String KEY_CONFIG_DIR = "config.dir";
	public static final String QUERY_XML_DOCUMENT = "req";
	public static final String DEFAULT_XML_ENCODING = "utf-8";

	/**
	 * GETṽfBXpb`
	 * @param arg0 NGXg
	 * @param arg1 X|X
	 * @throws ServletException T[ubg̎sɎs
	 * @throws IOException X|X̏o͂Ɏs
	 */
	protected void doGet(HttpServletRequest arg0, HttpServletResponse arg1)
		throws ServletException, IOException {

		String enableGetMethod = getInitParameter(KEY_ENABLE_GET_METHOD);
		if("true".equals(enableGetMethod)) {
			// GETɂANZXĂꍇ͎s
			execute(arg0, arg1);
		} else {
			// GET֎~Ăꍇ̓G[Ƃ
			throw new ServletException("access using get method is not recognized on current run mode.");
		}
	}

	/**
	 * POSTṽfBXpb`
	 * @param arg0 NGXg
	 * @param arg1 X|X
	 * @throws ServletException T[ubg̎sɎs
	 * @throws IOException X|X̏o͂Ɏs
	 */
	protected void doPost(HttpServletRequest arg0, HttpServletResponse arg1)
		throws ServletException, IOException {
		execute(arg0, arg1);
	}
	/**
	 * v͂̎s
	 * @param request NGXg
	 * @param response X|X
	 * @throws ServletException T[ubg̎sɎs
	 * @throws IOException X|X̏o͂Ɏs
	 */
	protected void execute(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String document = request.getParameter(QUERY_XML_DOCUMENT);
		if(document == null || document.trim().length() == 0) {
			// XMLhLgMĂȂꍇ
			throw new ServletException("xml document is required.");
		}

		String dsruri = getInitParameter(KEY_DSRURI);
		if(dsruri == null || dsruri.trim().length() == 0) {
			throw new ServletException("servlet initial parameter 'dsruri' is not specified.");
		}
		String xmlEncoding = getInitParameter(KEY_XML_ENCODING);
		if(xmlEncoding == null || xmlEncoding.trim().length() == 0) {
			xmlEncoding = DEFAULT_XML_ENCODING;
		}
		String configDir = getInitParameter(KEY_CONFIG_DIR);
		if(configDir == null || configDir.trim().length() == 0) {
			configDir = ".";
		} else {
			// ReLXgpXApXɕϊ
			configDir = getServletContext().getRealPath(configDir);
		}
		try {
			// 
			String result = DocumentProcessor.newInstance(dsruri, xmlEncoding, configDir).search(document);
			// ʂԂ
			response.setContentType("text/xml; charset=" + xmlEncoding);
			response.setCharacterEncoding(xmlEncoding);
			// XML̏o
			PrintWriter pw = response.getWriter();
			pw.println(result);
			pw.flush();
		} catch (Exception e) {
			// Q
			response.setContentType("text/plain; charset=" + xmlEncoding);
			response.setCharacterEncoding(xmlEncoding);
			e.printStackTrace(response.getWriter());
		}
	}
}
