/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.tools.update;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public final class RSSUpdate {
    public static final String RSS_CLASSFILE_URL = "http://localhost/ja/RSS/archives/latest_classfiles/";
    public static final String RSS_CLASSFILE = "rss1b.jar";

    protected void replaceClassFile(String filename, InputStream in) throws Exception {
        BufferedInputStream bin = new BufferedInputStream(in);
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(filename));
        byte[] buffer = new byte[65536];
        int receivedBytes = 0;
        while ((receivedBytes = bin.read(buffer, 0, buffer.length)) > 0) {
            bout.write(buffer, 0, receivedBytes);
        }
        bin.close();
        bout.flush();
        bout.close();
    }

    protected void download(String downloadFrom, String filename) throws Exception {
        URL dest = new URL(downloadFrom + filename);
        HttpURLConnection con = (HttpURLConnection)dest.openConnection();
        int responseCode = con.getResponseCode();
        switch (responseCode) {
            case 301: 
            case 302: {
                System.err.println("\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u30d5\u30a1\u30a4\u30eb\u304c\u79fb\u52d5\u3055\u308c\u3066\u3044\u307e\u3059");
                break;
            }
            case 204: 
            case 404: {
                System.err.println("\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u305b\u3093");
                break;
            }
            case 200: {
                System.err.println(dest.toString() + "\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f");
                this.replaceClassFile(filename, con.getInputStream());
                break;
            }
            default: {
                System.err.println(dest.toString() + "\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u4e2d\u306b\u30a8\u30e9\u30fc\u30b3\u30fc\u30c9(" + responseCode + ")\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
        }
        con.disconnect();
    }

    public static final void main(String[] args) throws Exception {
        String downloadFrom = args.length > 0 ? new String(args[0]) : new String(RSS_CLASSFILE_URL);
        RSSUpdate updater = new RSSUpdate();
        updater.download(downloadFrom, RSS_CLASSFILE);
    }
}

