/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.router;

import java.io.Serializable;
import java.util.Calendar;

public class SiteLock
implements Serializable {
    private static final long serialVersionUID = 6895276413172801180L;
    protected String fqdn = null;
    protected String robotId;
    protected boolean gc = false;
    protected long lastUpdateTime = Calendar.getInstance().getTimeInMillis();

    public SiteLock(String dn, String id) {
        this.fqdn = dn;
        this.robotId = id;
    }

    public String getSiteName() {
        if (this.fqdn != null) {
            return new String(this.fqdn);
        }
        return null;
    }

    public String toString() {
        return this.getSiteName();
    }

    public String getRobotId() {
        return this.robotId;
    }

    public void markGC() {
        this.gc = true;
    }

    public long getLastAccessTime() {
        return this.lastUpdateTime;
    }

    public boolean isBroken() {
        return this.gc;
    }

    public void touch() {
        this.lastUpdateTime = Calendar.getInstance().getTimeInMillis();
    }
}

