/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.router;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.logical_paradox.rss.dsync.SyncCommand;
import org.logical_paradox.rss.router.RNodeClientFactoryImpl;
import org.logical_paradox.rss.router.RoutingNodeClient;
import org.logical_paradox.rss.util.RandomKeyGenerator;

public class RoutingNodeClientImpl
extends UnicastRemoteObject
implements RoutingNodeClient {
    private static final long serialVersionUID = 8983895250691567089L;
    private String robotKey = null;
    private RNodeClientFactoryImpl parent = null;

    public RoutingNodeClientImpl(RNodeClientFactoryImpl p) throws RemoteException {
        this.parent = p;
        this.robotKey = "SNODE:" + RandomKeyGenerator.getUniqKey();
    }

    public String getNodeId() throws RemoteException {
        return this.robotKey;
    }

    public String getParentNodeId() throws RemoteException {
        return this.parent.getNodeId();
    }

    public SyncCommand[] getSyncData() throws RemoteException {
        SyncCommand[] e = null;
        try {
            e = this.parent.getModifiedSyncData(this.robotKey);
        }
        catch (Exception se) {
            se.printStackTrace();
            throw new RemoteException(se.getMessage());
        }
        return e;
    }

    public void sync(SyncCommand[] locks) throws Exception {
        this.parent.sync(locks);
    }

    public String[] getAllowedRoutingIPRanges() throws Exception {
        return this.parent.getAllowedRoutingIPRanges();
    }
}

