/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.robot;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.net.IPAddressRangeSet;
import org.logical_paradox.common.net.IPAddressRangeSetFactory;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.rss.IllegalObjectStateException;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSProperties;
import org.logical_paradox.rss.dsync.SyncQueueException;
import org.logical_paradox.rss.http.HREFCollector;
import org.logical_paradox.rss.http.NoIndexException;
import org.logical_paradox.rss.http.Site;
import org.logical_paradox.rss.http.URLPool;
import org.logical_paradox.rss.http.URLSuspender;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.lcmgr.RSSLocalContentsMgr;
import org.logical_paradox.rss.lookup.Lookup;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.robot.RSSNavigatorConfig;
import org.logical_paradox.rss.robot.event.SNodeDSyncEventListener;
import org.logical_paradox.rss.router.RNodeClientFactory;
import org.logical_paradox.rss.router.RNodeDSyncMngr;
import org.logical_paradox.rss.router.RoutingNodeClient;
import org.logical_paradox.rss.router.SiteLock;
import org.logical_paradox.rss.router.algorithm.RoutingAlgorithm;
import org.logical_paradox.rss.util.RandomKeyGenerator;

public class RSSWebNavigator {
    private static final Log log = LogFactory.getLog(RSSWebNavigator.class);
    public static final String NAVIGATIOR_CONF_FILENAME = "../conf/rssnavigator.conf";
    private RSSNavigatorConfig cfg = null;
    private URLPool urls = new URLPool();
    private int nowFetchCnt = 0;
    private int maxFetchCnt = 0;
    private RoutingAlgorithm algo = null;
    private Hashtable<String, Site> sites = new Hashtable();
    private RNodeClientFactory rnode = null;
    private RoutingNodeClient rnClient = null;
    private String robotId = null;
    private int limKeepLocks = 0;
    private URLSuspender suspender = new URLSuspender();
    private long siteLockLastGCTime = 0L;
    private boolean shutdownFlg = false;
    private boolean navimode = true;
    private RSSLocalContentsMgr lcm = null;
    private RNodeDSyncMngr dsyncman;
    protected boolean flg_EchoURL = true;

    protected RSSWebNavigator() {
    }

    public static RSSWebNavigator getNavigator(String filename) throws IllegalObjectStateException, RSSIllegalConfigException, IOException {
        RSSWebNavigator navigator = new RSSWebNavigator();
        navigator.cfg = new RSSNavigatorConfig(filename != null ? filename : NAVIGATIOR_CONF_FILENAME);
        navigator.navimode = navigator.cfg.getNavigationMode();
        log.info((Object)("RSS\u63a2\u7d22\u30b7\u30b9\u30c6\u30e0\u3092" + (navigator.navimode ? "\u5206\u6563\u30b7\u30b9\u30c6\u30e0" : "\u30b9\u30bf\u30f3\u30c9\u30a2\u30ed\u30fc\u30f3\u30b7\u30b9\u30c6\u30e0") + "\u3068\u3057\u3066\u8a2d\u5b9a\u3057\u307e\u3059"));
        navigator.maxFetchCnt = navigator.cfg.getDebugTraceURLs();
        navigator.flg_EchoURL = navigator.cfg.getEchoURL();
        navigator.limKeepLocks = navigator.cfg.getKeepLocks();
        navigator.siteLockLastGCTime = Calendar.getInstance().getTimeInMillis();
        navigator.algo = navigator.cfg.getRoutingAlgorithm();
        log.info((Object)("\u7d4c\u8def\u6c7a\u5b9a\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u304c'" + navigator.algo.getAlgorithmName() + "'\u306b\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f"));
        try {
            if (!navigator.navimode) {
                String root = navigator.cfg.getRoot();
                if (root == null || root.trim().length() == 0) {
                    throw new RSSIllegalConfigException();
                }
                navigator.urls.add(root);
                navigator.robotId = "SNODE:" + RandomKeyGenerator.getUniqKey();
            } else {
                log.info((Object)"\u7d4c\u8def\u6c7a\u5b9a\u30ce\u30fc\u30c9\u306b\u30b5\u30fc\u30d3\u30b9\u30a4\u30f3\u3057\u3066\u3044\u307e\u3059");
                Lookup lookup = LookupFactory.getLookup(navigator.cfg.getDistServRegURL());
                navigator.rnode = (RNodeClientFactory)lookup.lookup(10);
                navigator.rnClient = navigator.rnode.bindSearchNode();
                navigator.robotId = navigator.rnClient.getNodeId();
                log.info((Object)("\u63a2\u7d22\u30ce\u30fc\u30c9\u304c\u7d4c\u8def\u6c7a\u5b9a\u30ce\u30fc\u30c9[" + navigator.rnode.getNodeId() + "]\u306b\u30d0\u30a4\u30f3\u30c9\u3055\u308c\u307e\u3057\u305f"));
                log.info((Object)("\u63a2\u7d22\u30ce\u30fc\u30c9ID: " + navigator.robotId));
                IPAddressRangeSet rangeSet = null;
                String httpStubModeString = RSSProperties.getString("stub.http.connection");
                if (httpStubModeString != null && Boolean.valueOf(httpStubModeString).booleanValue()) {
                    log.info((Object)"\u30c6\u30b9\u30c8\u63a5\u7d9a\u30e2\u30fc\u30c9\u306e\u305f\u3081\uff0cIP\u7bc4\u56f2\u3092\u5236\u9650\u3057\u307e\u305b\u3093");
                } else {
                    String[] ipranges = navigator.rnClient.getAllowedRoutingIPRanges();
                    if (ipranges != null && ipranges.length > 0) {
                        log.info((Object)("IP\u30a2\u30c9\u30ec\u30b9\u306e\u7bc4\u56f2\u3092\u5236\u9650\u3057\u3066\u3044\u307e\u3059: " + ipranges.length + "\u4ef6"));
                        rangeSet = IPAddressRangeSetFactory.getIPAddressRangeSet();
                        rangeSet.setRanges(ipranges);
                    }
                }
                navigator.dsyncman = new RNodeDSyncMngr(navigator.cfg, navigator.rnClient, 1000L, navigator.urls, rangeSet);
                navigator.dsyncman.addListener(new SNodeDSyncEventListener(navigator));
                navigator.dsyncman.start();
            }
        }
        catch (MalformedURLException me) {
            log.info((Object)"\u7d4c\u8def\u6c7a\u5b9a\u30ce\u30fc\u30c9\u9078\u629e\u30b5\u30fc\u30d0\u30fc\u306eURL\u304c\u304a\u304b\u3057\u3044");
            throw new IllegalObjectStateException(me.getMessage());
        }
        catch (RemoteException re) {
            log.info((Object)"\u7d4c\u8def\u6c7a\u5b9a\u30ce\u30fc\u30c9\u3068\u306e\u901a\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            throw new IllegalObjectStateException(re.getMessage());
        }
        catch (Exception e) {
            log.info((Object)("\u305d\u306e\u4ed6\u306e\u539f\u56e0\u306b\u3088\u308b\u30a8\u30e9\u30fc : " + e.getMessage()));
            e.printStackTrace();
            throw new IllegalObjectStateException(e.getMessage());
        }
        return navigator;
    }

    public void enableLocalContentsMgr(String filename) throws RSSIllegalConfigException {
        if (this.lcm == null) {
            this.lcm = new RSSLocalContentsMgr(this.navimode, filename);
        }
        this.lcm.start();
    }

    public void disableLocalContentsMgr() {
        if (this.lcm != null) {
            this.lcm.done();
        }
    }

    public boolean isLocked(String url) {
        boolean rc = true;
        String siteName = this.getSiteNameByURL(url);
        if (siteName == null) {
            return false;
        }
        if (this.dsyncman.findLock(siteName, this.getRobotId()) == null && this.dsyncman.numOfMyLocks(this.getRobotId()) >= this.limKeepLocks) {
            try {
                this.dsyncman.poolURL(url);
            }
            catch (SyncQueueException se) {
                // empty catch block
            }
            return false;
        }
        if (!this.requireSiteLock(siteName, this.getRobotId())) {
            log.info((Object)(url + "\u3092\u30ed\u30c3\u30af\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f"));
            return false;
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllowed(String url) {
        boolean rc = false;
        String siteName = this.getSiteNameByURL(url);
        if (siteName == null) {
            return false;
        }
        Hashtable<String, Site> hashtable = this.sites;
        synchronized (hashtable) {
            Site so = this.sites.get(siteName);
            if (so == null) {
                try {
                    log.trace((Object)"\u30b5\u30a4\u30c8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u4f5c\u6210\u3057\u3066\u3044\u307e\u3059");
                    so = Site.getInstance(url, this.cfg.getProperty("HTTP_USER_AGENT"));
                    this.sites.put(siteName, so);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            rc = !so.hasRule() || so.isAllowed(url, this.cfg.getHttpUserAgent());
        }
        log.trace((Object)(url + "\u306f\uff0c" + (rc ? "\u8a31\u53ef" : "\u7981\u6b62") + "\u3055\u308c\u3066\u3044\u307e\u3059"));
        return rc;
    }

    protected boolean requireSiteLock(String dn, String rid) {
        if (this.dsyncman.findLock(dn, rid) != null) {
            return true;
        }
        boolean rc = true;
        SiteLock l = new SiteLock(dn, rid);
        try {
            rc = this.dsyncman.lock(l);
        }
        catch (SyncQueueException se) {
            se.printStackTrace();
            System.out.println(se.getMessage());
            rc = false;
        }
        return rc;
    }

    public void setRoutingAlgorithm(RoutingAlgorithm r) {
        this.algo = r;
    }

    public String getRobotId() {
        return this.robotId;
    }

    public void close() throws RemoteException {
        if (this.lcm != null) {
            log.info((Object)"\u30ed\u30fc\u30ab\u30eb\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u3092\u505c\u6b62\u3057\u3066\u3044\u307e\u3059");
            try {
                this.disableLocalContentsMgr();
                log.info((Object)"\u30ed\u30fc\u30ab\u30eb\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u3092\u505c\u6b62\u3057\u307e\u3057\u305f");
            }
            catch (Exception e) {
                log.error((Object)("\u505c\u6b62\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f:\n" + e.getMessage()));
            }
        }
        if (!this.navimode) {
            return;
        }
        log.info((Object)("\u7d4c\u8def\u6c7a\u5b9a\u30ce\u30fc\u30c9\u304b\u3089\u63a2\u7d22\u30ce\u30fc\u30c9'" + this.getRobotId() + "'\u3092\u5207\u308a\u96e2\u3057\u3066\u3044\u307e\u3059"));
        if (this.rnode == null) {
            throw new RemoteException("navigator has been already closed");
        }
        this.rnode.unbindSearchNode(this.getRobotId());
        log.info((Object)("'" + this.getRobotId() + "'\u306f\uff0c\u7d4c\u8def\u6c7a\u5b9a\u30ce\u30fc\u30c9\u304b\u3089\u5207\u308a\u96e2\u3055\u308c\u307e\u3057\u305f"));
        this.rnode = null;
        this.rnClient = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendContents(WebContents contents) throws IllegalObjectStateException, MalformedURLException, IOException {
        Vector<String> anchors;
        boolean needToStore;
        block18: {
            needToStore = true;
            if (Calendar.getInstance().getTimeInMillis() - this.siteLockLastGCTime >= this.cfg.getSiteLockExpire()) {
                log.trace((Object)"\u63a2\u7d22\u30ed\u30c3\u30af\u306e\u30ac\u30d9\u30fc\u30b8\u30b3\u30ec\u30af\u30bf\u3092\u8d77\u52d5\u3057\u307e\u3057\u305f");
                this.dsyncman.gc();
                this.siteLockLastGCTime = Calendar.getInstance().getTimeInMillis();
            }
            if (contents == null) {
                return;
            }
            if (contents.isRobotsTxtFlg()) {
                this.releaseSearchLock(contents);
                return;
            }
            if (StringUtils.isEmpty((String)contents.getDocument())) {
                return;
            }
            anchors = null;
            try {
                anchors = HREFCollector.collect(contents.getOriginalDocument());
            }
            catch (NoIndexException noe) {
                if (!noe.isFollowable()) break block18;
                anchors = noe.getAnchorsInThisPage();
                needToStore = false;
            }
        }
        Vector<String> an = HREFCollector.getAnchorsAsABSPath(contents.getURL(), anchors);
        if (an == null) {
            return;
        }
        int receives = this.maxFetchCnt == 0 || an.size() + this.nowFetchCnt < this.maxFetchCnt ? an.size() : this.maxFetchCnt - this.nowFetchCnt;
        int nowURLs = this.urls.size();
        try {
            for (int i = 0; i < receives; ++i) {
                if (this.dsyncman != null && nowURLs >= this.cfg.getKeepUrls() && this.navimode) {
                    this.dsyncman.poolURL(an.elementAt(i));
                    continue;
                }
                this.urls.add(an.elementAt(i));
                ++nowURLs;
            }
        }
        catch (SyncQueueException se) {
            // empty catch block
        }
        this.nowFetchCnt += receives;
        if (this.lcm != null && needToStore) {
            RSSLocalContentsMgr rSSLocalContentsMgr = this.lcm;
            synchronized (rSSLocalContentsMgr) {
                while (!this.lcm.isReceivable()) {
                    try {
                        this.lcm.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            this.lcm.store(contents);
        }
    }

    public void releaseSearchLock(WebContents contents) throws IllegalObjectStateException {
        String dn = this.getSiteNameByURL(contents.getLocation());
        if (dn == null) {
            return;
        }
        Site s = this.sites.get(dn);
        if (s == null) {
            log.warn((Object)"\u30b5\u30a4\u30c8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u306a\u3044\u306e\u3067\u7121\u8996\u3057\u307e\u3059");
            return;
        }
        if (StringUtils.isEmpty((String)contents.getDocument())) {
            log.trace((Object)("URL: " + contents.getLocation() + "\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3067\u3057\u305f"));
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(contents.getDocument().getBytes());
            try {
                s.getRuleFromTheSite(in);
                log.trace((Object)("\u30b5\u30a4\u30c8'" + dn + "'\u306e\u30eb\u30fc\u30eb\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f"));
            }
            catch (IOException ie) {
                log.error((Object)"robots.txt\u306e\u89e3\u6790\u306b\u5931\u6557");
            }
        }
        try {
            this.sites.put(dn, s);
            String[] releasedURLs = this.suspender.release(dn);
            if (releasedURLs != null) {
                this.pushbackURLs(releasedURLs);
            }
            log.trace((Object)("\u30b5\u30a4\u30c8'" + dn + "'\u306e\u63a2\u7d22\u6291\u5236\u72b6\u614b\u3092\u89e3\u653e\u3057\u307e\u3057\u305f"));
        }
        catch (IllegalArgumentException ie) {
            log.trace((Object)("\u30b5\u30a4\u30c8'" + dn + "'\u306e\u89e3\u653e\u306b\u5931\u6557\u3057\u307e\u3057\u305f"), (Throwable)ie);
        }
    }

    public String getNextURL() {
        String rc = null;
        while ((rc = this.algo.nextURL(this.urls)) != null) {
            String dn;
            block4: {
                try {
                    if (!this.suspender.isSuspended(rc) || (dn = this.getSiteNameByURL(rc)) == null) break block4;
                    this.suspender.suspend(Site.getInstance(dn, this.cfg.getHttpUserAgent()), rc);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
            }
            if ((dn = this.getSiteNameByURL(rc)) == null || !this.isLocked(rc)) continue;
            if (this.sites.get(dn) == null) {
                Site s = Site.getInstance(rc, this.cfg.getHttpUserAgent());
                this.suspender.suspend(s, rc);
                this.algo.removeFromHistory(rc);
                rc = s.getRobotsTxtURL();
                this.sites.put(dn, s);
                break;
            }
            if (!this.isAllowed(rc)) continue;
            break;
        }
        return rc;
    }

    private void pushbackURLs(String[] u) {
        if (u == null) {
            return;
        }
        for (int i = 0; i < u.length; ++i) {
            try {
                this.urls.add(u[i]);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public int getQueueSize() {
        return this.urls.size();
    }

    public void waitUntilEmpty() {
        this.urls.waitUntilEmpty();
    }

    public boolean isFinished() {
        if (this.shutdownFlg) {
            return true;
        }
        return this.countSuspendedSites() + this.urls.size() == 0 && this.maxFetchCnt > 0 && this.nowFetchCnt >= this.maxFetchCnt;
    }

    public int countSuspendedSites() {
        return this.suspender.size();
    }

    private String getSiteNameByURL(String url) {
        try {
            URL u = new URL(url);
            return u.getHost() + (u.getPort() > 0 ? ":" + u.getPort() : "");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public boolean getNavigationMode() {
        return this.navimode;
    }

    public void shutdown() {
        this.shutdownFlg = true;
    }
}

