/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm.accessor;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.util.ExceptionUtils;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;

public class ContentsAccessorFactory {
    private static final Log log = LogFactory.getLog(ContentsAccessorFactory.class);
    private Class seed;
    private String initparam;
    private HashMap<String, ContentsAccessor> instances = new HashMap();
    private String dsruri;

    public ContentsAccessorFactory(String classname, String dsr, String initp) throws ClassNotFoundException {
        this.seed = Class.forName(classname);
        this.initparam = initp;
        this.dsruri = dsr;
    }

    public ContentsAccessor getAccessor() throws IllegalArgumentException {
        try {
            String initp = this.initparam != null ? this.initparam : "";
            ContentsAccessor accessor = this.instances.get(initp);
            if (accessor != null) {
                return accessor;
            }
            accessor = (ContentsAccessor)this.seed.newInstance();
            accessor.setDSRURI(this.dsruri);
            if (!StringUtils.isEmpty((String)initp)) {
                accessor.init(this.initparam);
            }
            this.instances.put(initp, accessor);
            return accessor;
        }
        catch (Exception e) {
            String stackTraceMsg = ExceptionUtils.stackTraceToString((Exception)e);
            log.error((Object)("\u30b3\u30f3\u30c6\u30f3\u30c4\u30a2\u30af\u30bb\u30b5\u751f\u6210\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f:[" + e.getMessage() + "]"), (Throwable)e);
            log.error((Object)stackTraceMsg);
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

