/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm;

import java.io.IOException;
import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;
import org.logical_paradox.rss.rcm.ContentsQueue;

public class RSSRCMConfig
extends RSSConfig {
    private boolean cfgRCMSwRunLog = false;
    private String cfgRCMRunLogFilename = "rssrcm.run.log";
    private String cfgRSSContentsMngrService = "";
    private int cfgInitialRegisterServices = 5;
    private int cfgInitialFinderServices = 10;
    private int cfgMaxRegisterServices = 15;
    private int cfgMaxFinderServices = 20;
    private String cfgRegisterServicePrefix = "";
    private int cfgAgentsPerRegister = 2;
    private int cfgRegistQueueSize = 262144;
    private int cfgContentsSendingInterval = 500;
    private int cfgContentsSendingScale = 20;
    private String cfgContentsAccessor = "";
    private String cfgContentsConnStr = "";
    private String cfgRSSDistributedServiceRegistry;
    private ContentsQueue q = null;

    public RSSRCMConfig(String fn) throws IOException, RSSIllegalConfigException {
        super(fn);
        String errmsg = this.checkResourceVariables();
        if (errmsg != null) {
            throw new RSSIllegalConfigException(errmsg);
        }
    }

    public boolean getRCMSwRunLog() {
        return this.cfgRCMSwRunLog;
    }

    public String getRCMRunLogFilename() {
        return this.cfgRCMRunLogFilename;
    }

    public String getRSSContentsMngrService() {
        return this.cfgRSSContentsMngrService;
    }

    public int getInitialRegisterServices() {
        return this.cfgInitialRegisterServices;
    }

    public int getMaxRegisterServices() {
        return this.cfgMaxRegisterServices;
    }

    public int getMaxFinderServices() {
        return this.cfgMaxFinderServices;
    }

    public String getRegisterServicePrefix() {
        return this.cfgRegisterServicePrefix;
    }

    public int getAgentsPerRegister() {
        return this.cfgAgentsPerRegister;
    }

    public int getRegistQueueSize() {
        return this.cfgRegistQueueSize;
    }

    public int getContentsSendingInterval() {
        return this.cfgContentsSendingInterval;
    }

    public int getContentsSendingScale() {
        return this.cfgContentsSendingScale;
    }

    public String getContentsAccessor() {
        return this.cfgContentsAccessor;
    }

    public String getContentsConnStr() {
        return this.cfgContentsConnStr;
    }

    public String getRSSDistributedServiceRegistry() {
        return this.cfgRSSDistributedServiceRegistry;
    }

    public ContentsQueue getContentsQueue() {
        return this.q;
    }

    public int getInitialFinderServices() {
        return this.cfgInitialFinderServices;
    }

    protected String checkResourceVariables() {
        String errmsg = "";
        try {
            this.cfgRCMSwRunLog = this.getPropertyAsBool("RCM_SW_RUNLOG");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "RCM_SW_RUNLOG\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        if (this.getProperty("RCM_RUNLOG_FILENAME") != null) {
            this.cfgRCMRunLogFilename = this.getProperty("RCM_RUNLOG_FILENAME");
        }
        this.cfgRSSContentsMngrService = this.getProperty("RSS_CONTENTS_MNGR_SERVICE");
        if (this.cfgRSSContentsMngrService == null) {
            errmsg = errmsg + "RSS_CONTENTS_MNGR_SERVICE\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\n";
        }
        this.cfgRSSDistributedServiceRegistry = this.getProperty("RSS_DSR");
        if (this.cfgRSSDistributedServiceRegistry == null) {
            errmsg = errmsg + "RSS_DSR\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\n";
        }
        try {
            this.cfgInitialRegisterServices = this.getPropertyAsInt("INITIAL_REGISTER_SERVICES");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "INITIAL_REGISTER_SERVICES\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.cfgInitialFinderServices = this.getPropertyAsInt("INITIAL_FINDER_SERVICES");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "INITIAL_FINDER_SERVICES\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.cfgMaxRegisterServices = this.getPropertyAsInt("MAX_REGISTER_SERVICES");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "MAX_REGISTER_SERVICES\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.cfgMaxFinderServices = this.getPropertyAsInt("MAX_FINDER_SERVICES");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "MAX_FINDER_SERVICES\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        this.cfgRegisterServicePrefix = this.getProperty("REGISTER_SERVICE_PREFIX");
        if (this.cfgRegisterServicePrefix == null) {
            errmsg = errmsg + "REGISTER_SERVICE_PREFIX\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\n";
        }
        try {
            this.cfgAgentsPerRegister = this.getPropertyAsInt("AGENTS_PER_REGISTER");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "AGENTS_PER_REGISTER\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.cfgRegistQueueSize = this.getPropertyAsInt("REGIST_QUEUE_SIZE");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "REGIST_QUEUE_SIZE\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.cfgContentsSendingInterval = this.getPropertyAsInt("CONTENTS_SENDING_INTERVAL");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "CONTENTS_SENDING_INTERVAL\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException ne) {
            // empty catch block
        }
        try {
            this.cfgContentsSendingScale = this.getPropertyAsInt("CONTENTS_SENDING_SCALE");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = errmsg + "CONTENTS_SENDING_SCALE\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException rSSNullValueException) {
            // empty catch block
        }
        this.cfgContentsAccessor = this.getProperty("CONTENTS_ACCESSOR");
        if (this.cfgContentsAccessor == null) {
            errmsg = errmsg + "CONTENTS_ACCESSOR\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\n";
        }
        if (this.getProperty("CONTENTS_CONNSTR") != null) {
            this.cfgContentsConnStr = this.getProperty("CONTENTS_CONNSTR");
        }
        if (errmsg.trim().length() > 0) {
            return errmsg;
        }
        if (this.getRegistQueueSize() > 0) {
            this.q = new ContentsQueue(this.getRegistQueueSize());
        }
        return null;
    }
}

