/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm;

import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.cli.Argument;
import org.logical_paradox.common.cli.ArgumentParser;
import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModule;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.rcm.ContentsFinder;
import org.logical_paradox.rss.rcm.ContentsFinderImpl;
import org.logical_paradox.rss.rcm.ContentsRegister;
import org.logical_paradox.rss.rcm.RCMContentsRegister;
import org.logical_paradox.rss.rcm.RCMContentsRegisterImpl;
import org.logical_paradox.rss.rcm.RSSContentsMngrService;
import org.logical_paradox.rss.rcm.RSSRCMConfig;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessorFactory;

public class RSSContentsMngrServiceImpl
extends UnicastRemoteObject
implements RSSContentsMngrService,
RSSSubModule {
    private static final long serialVersionUID = -583832132972585596L;
    private static final Log log = LogFactory.getLog(RSSContentsMngrServiceImpl.class);
    public static final String RCM_CONF_FILENAME = "../conf/rssrcm.conf";
    private String rcmServiceName = null;
    private RSSRCMConfig cfg = null;
    private int registerServiceCnt = 1;
    private int finderServiceCnt = 1;
    private ContentsAccessorFactory accessorFactory = null;
    private ArrayList<RCMContentsRegister> registers = null;
    private ArrayList<ContentsFinder> finders = null;
    private int registerIdx = 0;
    private int finderIdx = 0;
    private final String rcmConfigFilename;

    public RSSContentsMngrServiceImpl() throws RemoteException {
        this.rcmConfigFilename = RCM_CONF_FILENAME;
    }

    public RSSContentsMngrServiceImpl(String filename) throws RemoteException {
        this.rcmConfigFilename = filename;
    }

    protected void init() throws Exception {
        this.registers = new ArrayList();
        this.finders = new ArrayList();
        log.info((Object)"\u30ed\u30b0\u30e9\u30a4\u30bf\u30fc\u3092\u521d\u671f\u5316\u3057\u307e\u3057\u305f");
        this.accessorFactory = new ContentsAccessorFactory(this.cfg.getContentsAccessor(), this.cfg.getRSSDistributedServiceRegistry(), this.cfg.getContentsConnStr());
        log.info((Object)"\u30ea\u30e2\u30fc\u30c8\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u3092\u69cb\u6210\u3057\u3066\u3044\u307e\u3059");
        for (int i = 0; i < this.cfg.getInitialRegisterServices(); ++i) {
            this.createRegister();
        }
        for (int j = 0; j < this.cfg.getInitialFinderServices(); ++j) {
            this.createFinder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFinder() throws Exception {
        ArrayList<ContentsFinder> arrayList = this.finders;
        synchronized (arrayList) {
            String serviceName = "FINDER_" + (this.finders.size() + 1);
            this.finders.add(new ContentsFinderImpl(serviceName, this.accessorFactory.getAccessor()));
            log.info((Object)("\u30d5\u30a1\u30a4\u30f3\u30c0\u30fc[" + serviceName + "]\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f"));
            ++this.finderServiceCnt;
        }
    }

    protected void createRegister() throws Exception {
        String serviceName = this.cfg.getRegisterServicePrefix() + this.registerServiceCnt;
        RCMContentsRegisterImpl r = new RCMContentsRegisterImpl(serviceName, this.cfg, this.accessorFactory.getAccessor());
        this.registers.add(r);
        Naming.rebind(serviceName, r);
        log.info((Object)("\u30ec\u30b8\u30b9\u30bf\u30b5\u30fc\u30d3\u30b9[" + serviceName + "]\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f"));
        ++this.registerServiceCnt;
    }

    public String[] getRegisterNames() throws RemoteException {
        return null;
    }

    public void gc() throws RemoteException {
    }

    public ContentsFinder getFinder() throws RemoteException {
        if (this.finderIdx >= this.finders.size()) {
            this.finderIdx = 0;
        }
        ContentsFinder finder = this.finders.get(this.finderIdx++);
        log.info((Object)("\u30d5\u30a1\u30a4\u30f3\u30c0\u30fc\u30b5\u30fc\u30d3\u30b9[" + finder.getName() + "\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f"));
        return finder;
    }

    public ContentsRegister getRegister() throws RemoteException {
        if (this.registerIdx >= this.registers.size()) {
            this.registerIdx = 0;
        }
        ContentsRegister r = this.registers.get(this.registerIdx++);
        log.info((Object)("\u30ec\u30b8\u30b9\u30bf\u30b5\u30fc\u30d3\u30b9[" + r.getRegisterName() + "]\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f"));
        return r;
    }

    public static void main(String[] args) throws Exception {
        String filename = null;
        for (Argument arg : ArgumentParser.parse((String[])args)) {
            if (!arg.isOption() || !"config".equals(arg.getName())) continue;
            filename = arg.getValue();
        }
        RSSContentsMngrServiceImpl server = null;
        server = filename == null ? new RSSContentsMngrServiceImpl() : new RSSContentsMngrServiceImpl(filename);
        server.startModule();
    }

    public void startModule() throws ModuleException {
        try {
            this.cfg = new RSSRCMConfig(this.rcmConfigFilename);
            this.rcmServiceName = LookupFactory.getLookup(this.cfg.getRSSDistributedServiceRegistry()).bind(20, this);
            this.init();
        }
        catch (Exception e) {
            throw new ModuleException(e);
        }
        log.info((Object)"\u30ea\u30e2\u30fc\u30c8\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u3092\u958b\u59cb\u3057\u307e\u3057\u305f");
    }

    public void suspendModule() throws ModuleException {
    }

    public void continueModule() throws ModuleException {
    }

    public void stopModule() throws ModuleException {
    }

    public String getName() throws RemoteException {
        return this.rcmServiceName;
    }

    public String getFqsn() throws RemoteException {
        return this.rcmServiceName + "@" + this.cfg.getRSSDistributedServiceRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean force) throws RemoteException {
        log.info((Object)"\u30b5\u30fc\u30d0\u30fc\u3092\u505c\u6b62\u3057\u307e\u3059");
        log.info((Object)"\u30b3\u30f3\u30c6\u30f3\u30c4\u767b\u9332\u30b5\u30fc\u30d3\u30b9\u3092\u505c\u6b62\u3057\u3066\u3044\u307e\u3059");
        ArrayList<Remote> arrayList = this.registers;
        synchronized (arrayList) {
            for (ContentsRegister contentsRegister : this.registers) {
                contentsRegister.shutdown();
                if (!(contentsRegister instanceof RCMContentsRegister)) continue;
                UnicastRemoteObject.unexportObject((RCMContentsRegister)contentsRegister, force);
            }
            this.registers.clear();
        }
        log.info((Object)"\u30b3\u30f3\u30c6\u30f3\u30c4\u691c\u7d22\u30b5\u30fc\u30d3\u30b9\u3092\u505c\u6b62\u3057\u3066\u3044\u307e\u3059");
        arrayList = this.finders;
        synchronized (arrayList) {
            for (ContentsFinder contentsFinder : this.finders) {
                UnicastRemoteObject.unexportObject(contentsFinder, force);
            }
            this.finders.clear();
        }
        try {
            log.info((Object)"\u30ea\u30e2\u30fc\u30c8\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u3092DSR\u304b\u3089\u5207\u308a\u96e2\u3057\u3066\u3044\u307e\u3059");
            LookupFactory.getLookup(this.cfg.getRSSDistributedServiceRegistry()).unbind(20, this.rcmServiceName);
        }
        catch (Exception e1) {
            throw new RemoteException(e1.getMessage());
        }
        UnicastRemoteObject.unexportObject(this, force);
        log.info((Object)"\u30b5\u30fc\u30d0\u30fc\u3092\u505c\u6b62\u3057\u307e\u3057\u305f");
    }
}

