/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.http.WebContents;

public class ContentsQueue {
    private static final Log log = LogFactory.getLog(ContentsQueue.class);
    protected WebContents[] queue = null;
    protected int topIdx = 0;
    protected int lastIdx = 0;

    public ContentsQueue(int qsize) throws IllegalArgumentException {
        if (qsize < 1) {
            throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u30b5\u30a4\u30ba:" + qsize);
        }
        this.queue = new WebContents[qsize];
        this.lastIdx = 0;
        this.topIdx = 0;
        for (int i = 0; i < qsize; ++i) {
            this.queue[i] = null;
        }
    }

    public boolean enqueue(WebContents lc) {
        if (this.queue[this.lastIdx] != null) {
            return false;
        }
        this.queue[this.lastIdx++] = lc;
        if (this.lastIdx == this.queue.length) {
            this.lastIdx = 0;
        }
        log.info((Object)("\u30a8\u30f3\u30ad\u30e5\u30fc:" + lc.getURL()));
        return true;
    }

    public WebContents dequeue() {
        if (this.queue[this.topIdx] == null || this.topIdx == this.lastIdx) {
            return null;
        }
        WebContents lc = this.queue[this.topIdx];
        this.queue[this.topIdx] = null;
        ++this.topIdx;
        if (this.topIdx == this.queue.length) {
            this.topIdx = 0;
        }
        log.info((Object)("\u30c7\u30ad\u30e5\u30fc:" + lc.getURL()));
        return lc;
    }
}

