/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.lookup.impl;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.logical_paradox.rss.Service;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.lookup.Lookup;

public class RMILookup
implements Lookup {
    private String bindTarget;
    private RSSDistributedServiceRegistry dsr;

    public RMILookup(String bt) throws MalformedURLException, RemoteException, NotBoundException {
        this.dsr = (RSSDistributedServiceRegistry)Naming.lookup(bt);
        this.bindTarget = bt;
    }

    public RMILookup() throws Exception {
    }

    public String bind(int type, Object o) throws Exception {
        Service r = (Service)o;
        String node = this.dsr.bind(type, r);
        Naming.rebind(node, r);
        return node;
    }

    public void unbind(int type, String name) throws Exception {
        this.dsr.unbind(type, name);
        Naming.unbind(name);
    }

    public void register(RSSDistributedServiceRegistry stub) throws Exception {
        Naming.rebind(stub.getName(), stub);
        this.dsr = stub;
    }

    public Object lookup(int type) throws Exception {
        return this.dsr.getService(type);
    }

    public Service lookup(String nodeId) throws Exception {
        if (this.dsr.getName().equals(nodeId)) {
            return this.dsr;
        }
        return this.dsr.getService(nodeId);
    }

    public String getBindTargetName() {
        return this.bindTarget;
    }

    public String[] services(int type) throws Exception {
        return this.dsr.services(type);
    }

    public void configure() throws Exception {
        this.dsr.configure();
    }

    public Service hug(Service stub) throws RemoteException {
        this.dsr.bind(1, stub);
        return this.dsr;
    }

    public Service hug(String name, Service stub) throws RemoteException {
        this.dsr.bind(1, name, stub);
        return this.dsr;
    }
}

