/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.http;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.logical_paradox.rss.http.Site;

public class URLSuspender {
    private Hashtable<String, URLSuspendedSite> sites = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(Site s, String url) throws IllegalArgumentException {
        if (s == null || s.getSiteName() == null) {
            throw new IllegalArgumentException();
        }
        URLSuspendedSite site = null;
        Hashtable<String, URLSuspendedSite> hashtable = this.sites;
        synchronized (hashtable) {
            site = this.sites.get(s.getSiteName());
            if (site == null) {
                site = new URLSuspendedSite(s);
            }
            site.add(url);
        }
        this.sites.put(s.getSiteName(), site);
    }

    public Site get(String sn) {
        URLSuspendedSite s = this.sites.get(sn);
        if (s == null) {
            return null;
        }
        return s.getSite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        boolean rc = false;
        Hashtable<String, URLSuspendedSite> hashtable = this.sites;
        synchronized (hashtable) {
            rc = this.sites.get(s) != null;
        }
        return rc;
    }

    public boolean isSuspended(Site s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return this.isSuspended(s.getSiteName());
    }

    public String[] release(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        URLSuspendedSite us = this.sites.get(s);
        if (us == null) {
            return null;
        }
        String[] urls = us.releaseAll();
        this.sites.remove(s);
        return urls;
    }

    public String[] release(Site s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return this.release(s.getSiteName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int urls = 0;
        Hashtable<String, URLSuspendedSite> hashtable = this.sites;
        synchronized (hashtable) {
            Enumeration<URLSuspendedSite> e = this.sites.elements();
            while (e.hasMoreElements()) {
                urls += e.nextElement().size();
            }
        }
        return urls;
    }

    class URLSuspendedSite {
        private Site site = null;
        private HashSet<String> urls = null;

        private URLSuspendedSite(Site s) {
            this.site = s;
            this.urls = new HashSet();
        }

        private void add(String url) {
            this.urls.add(url);
        }

        private void remove(String url) {
            this.urls.remove(url);
        }

        private boolean isContained(String url) {
            return this.urls.contains(url);
        }

        private int size() {
            return this.urls.size();
        }

        private Site getSite() {
            return this.site;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] releaseAll() {
            Vector<String> list = new Vector<String>();
            HashSet<String> hashSet = this.urls;
            synchronized (hashSet) {
                Iterator<String> i = this.urls.iterator();
                while (i.hasNext()) {
                    list.addElement(i.next().toString());
                }
                this.urls.removeAll(this.urls);
            }
            return list.toArray(new String[1]);
        }
    }
}

