/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLPool {
    private Hashtable<String, HashSet<String>> domain = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String url) throws MalformedURLException {
        Hashtable<String, HashSet<String>> hashtable = this.domain;
        synchronized (hashtable) {
            String dn = this.getDomainName(url);
            if (dn == null || dn.trim().length() == 0) {
                throw new MalformedURLException();
            }
            HashSet<String> s = this.domain.get(dn);
            if (s == null) {
                s = new HashSet();
                this.domain.put(dn, s);
            }
            s.add(url);
            this.domain.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String[] urls) throws MalformedURLException {
        Hashtable<String, HashSet<String>> hashtable = this.domain;
        synchronized (hashtable) {
            for (String url : urls) {
                if (urls == null) continue;
                this.add(url);
            }
            this.domain.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Iterator<String> i) throws MalformedURLException {
        Hashtable<String, HashSet<String>> hashtable = this.domain;
        synchronized (hashtable) {
            while (i.hasNext()) {
                this.add(i.next());
            }
            this.domain.notifyAll();
        }
    }

    public String[] domains(int idx, int len) {
        String[] d = this.domains();
        Vector<String> p = new Vector<String>();
        for (int i = 0; i < len && i < d.length; ++i) {
            p.addElement(d[i]);
        }
        return p.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] domains() {
        Set<String> keys = null;
        Hashtable<String, HashSet<String>> hashtable = this.domain;
        synchronized (hashtable) {
            keys = this.domain.keySet();
        }
        if (keys == null) {
            return null;
        }
        return keys.toArray(new String[0]);
    }

    public String[] urls(String dn) {
        HashSet<String> set = this.domain.get(dn);
        if (set == null) {
            return null;
        }
        return set.toArray(new String[0]);
    }

    public Iterator<String> getURLIterator(String dn) {
        HashSet<String> set = this.domain.get(dn);
        if (set == null) {
            return null;
        }
        return set.iterator();
    }

    protected String getDomainName(String url) throws MalformedURLException {
        URL u = new URL(url);
        String siteName = u.getHost();
        return siteName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String url) throws MalformedURLException {
        Hashtable<String, HashSet<String>> hashtable = this.domain;
        synchronized (hashtable) {
            String dn = this.getDomainName(url);
            if (dn == null || dn.trim().length() == 0) {
                throw new MalformedURLException();
            }
            HashSet<String> set = this.domain.get(dn);
            if (set == null) {
                return;
            }
            set.remove(url);
            if (set.size() == 0) {
                this.domain.remove(dn);
            }
            this.domain.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDomain(String domainname) {
        Hashtable<String, HashSet<String>> hashtable = this.domain;
        synchronized (hashtable) {
            HashSet<String> domainSet = this.domain.remove(domainname);
            if (domainSet != null) {
                domainSet.clear();
            }
            this.domain.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int remain = 0;
        Hashtable<String, HashSet<String>> hashtable = this.domain;
        synchronized (hashtable) {
            Enumeration<HashSet<String>> e = this.domain.elements();
            while (e.hasMoreElements()) {
                HashSet<String> s = e.nextElement();
                remain += s.size();
            }
            this.domain.notifyAll();
        }
        return remain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean rc = false;
        Hashtable<String, HashSet<String>> hashtable = this.domain;
        synchronized (hashtable) {
            rc = this.domain.isEmpty();
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmpty() {
        Hashtable<String, HashSet<String>> hashtable = this.domain;
        synchronized (hashtable) {
            while (this.domain.isEmpty()) {
                try {
                    this.domain.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

