/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.logical_paradox.rss.http.AnchorCollectionCallback;
import org.logical_paradox.rss.http.NoIndexException;
import org.logical_paradox.rss.http.ParserGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HREFCollector {
    public static Vector<String> collect(String contents) throws NoIndexException {
        ParserGetter gtr = new ParserGetter();
        AnchorCollectionCallback cb = new AnchorCollectionCallback();
        byte[] b = contents.getBytes();
        if (b == null) {
            return null;
        }
        InputStreamReader ir = new InputStreamReader(new ByteArrayInputStream(b));
        try {
            gtr.getParser().parse(ir, cb, true);
        }
        catch (IOException ioe) {
            return null;
        }
        return cb.getAnchors();
    }

    public static Vector<String> getAnchorsAsABSPath(URL u, Vector<String> a) {
        if (a == null || u == null) {
            return null;
        }
        Vector<String> anchors = new Vector<String>();
        for (int i = 0; i < a.size(); ++i) {
            try {
                String absoluteURL = new URL(u, a.elementAt(i)).toString();
                if (!absoluteURL.startsWith("http") || absoluteURL.startsWith("https")) continue;
                anchors.addElement(absoluteURL);
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return anchors;
    }
}

