/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.dsr;

import java.io.Serializable;
import java.util.Stack;
import org.logical_paradox.rss.dsr.AlreadyTracedException;
import org.logical_paradox.rss.dsr.Route;

public class Message
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -165920728326655367L;
    public static final int MSG_TYPE_CD_DISCOVER = 10;
    public static final int MSG_TYPE_CD_TRACE = 20;
    private String targetName;
    private int discoverType;
    private int traceLevel;
    private int currentLevel;
    private Stack<Route> route;

    public Message() {
        this.route = new Stack();
    }

    public Message(Message msg) {
        this.route = (Stack)msg.route.clone();
        this.targetName = msg.targetName == null ? null : msg.targetName;
        this.discoverType = msg.discoverType;
        this.traceLevel = msg.getTraceLevel();
        this.currentLevel = msg.getCurrentLevel();
    }

    public void setTargetName(String name) {
        this.targetName = name;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTraceLevel(int tl) {
        this.traceLevel = tl;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public void setDiscoverType(int dt) {
        this.discoverType = dt;
    }

    public int getDiscoverType() {
        return this.discoverType;
    }

    public void push(Route r) throws AlreadyTracedException {
        this.route.push(r);
    }

    public Route pop() {
        return this.route.pop();
    }

    public void incrementLevel() {
        ++this.currentLevel;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }
}

