/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm.accessor.mysql.validator;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.logical_paradox.rss.rcm.accessor.mysql.validator.ConnectionValidation;

public class ConnectionValidator
extends Thread {
    private final List<ConnectionValidation> validations = new ArrayList<ConnectionValidation>();
    private final long interval;

    public ConnectionValidator(long msec) {
        this.interval = msec;
        this.setDaemon(true);
    }

    public void add(ConnectionValidation validation) {
        this.validations.add(validation);
    }

    public void closeAll() {
        for (ConnectionValidation validation : this.validations) {
            try {
                validation.close();
            }
            catch (SQLException sQLException) {}
        }
        this.validations.clear();
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep(this.interval);
                ArrayList<ConnectionValidation> closedConnections = new ArrayList<ConnectionValidation>();
                for (ConnectionValidation validation : this.validations) {
                    try {
                        validation.ping();
                    }
                    catch (SQLException e) {
                        closedConnections.add(validation);
                    }
                }
                for (ConnectionValidation validation : closedConnections) {
                    try {
                        validation.close();
                    }
                    catch (SQLException e) {}
                }
                this.validations.removeAll(closedConnections);
            }
        }
        catch (InterruptedException e) {
            this.close();
            return;
        }
    }

    public void shutdown() {
        this.interrupt();
    }

    protected void close() {
        this.closeAll();
    }
}

