/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ArgumentParserTest.java,v 1.1 2005/02/28 13:27:52 rampil Exp $
 */
package org.logical_paradox.common.cli;

import junit.framework.TestCase;

/**
 * R}hCp[U[̎
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class ArgumentParserTest extends TestCase {

	/**
	 * Constructor for ArgumentParserTest.
	 * @param arg0
	 */
	public ArgumentParserTest(String arg0) {
		super(arg0);
	}
	/**
	 * SăIvṼp^[
	 */
	public void testAllOptions() {
		String[] line = new String[] {
			"-D=sample=test","-Xm=yyyymmdd","--interface-factory=org.logical_paradox.common.cli.DefaultFactory"
			};
		Argument[] args = ArgumentParser.parse(line);

		assertNotNull(args);
		assertEquals(3, args.length);
		// 0
		assertEquals("D", args[0].getName());
		assertEquals("sample=test", args[0].getValue());
		// 1
		assertEquals("Xm", args[1].getName());
		assertEquals("yyyymmdd", args[1].getValue());
		// 2
		assertEquals("interface-factory", args[2].getName());
		assertEquals("org.logical_paradox.common.cli.DefaultFactory", args[2].getValue());
	}
	/**
	 * Săt@C̃p^[
	 */
	public void testAllArguments() {
		String[] line = new String[] {
			"http://www.google.com", "c:\\sample\\test.txt"
			};

		Argument[] args = ArgumentParser.parse(line);

		assertNotNull(args);
		assertEquals(2, args.length);

		// 0
		assertNull(args[0].getName());
		assertEquals("http://www.google.com", args[0].getValue());
		// 1
		assertNull(args[1].getName());
		assertEquals("c:\\sample\\test.txt", args[1].getValue());
	}
	/**
	 * IvVƃt@C݂p^[
	 *
	 */
	public void testComplex() {
		String[] line = new String[] {
			"--foo--bar--com==sample", "-Xm256", "", "--\=EUC", "-Yp=512"
		};
		
		Argument[] args = ArgumentParser.parse(line);

		assertNotNull(args);
		assertEquals(5, args.length);

		// 0
		assertEquals("foo--bar--com", args[0].getName());
		assertEquals("=sample", args[0].getValue());
		// 1
		assertNull(args[1].getName());
		assertEquals("-Xm256", args[1].getValue());
		// 2
		assertNull(args[2].getName());
		assertEquals("", args[2].getValue());
		// 3
		assertEquals("\", args[3].getName());
		assertEquals("EUC", args[3].getValue());
		// 4
		assertEquals("Yp", args[4].getName());
		assertEquals("512", args[4].getValue());
	}
}
