/*-
 * Copyright (C) 2008 Speecys Corporation
 *		Toshiaki Nozawa <nozawa@speecys.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the Speecys Corporation.
 * 4. Neither the name of The Speecys Corporation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE SPEECYS CORPORATION AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE CORPORATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __LIBUTIL_H__
#define __LIBUTIL_H__

#include <sys/time.h>
#include <sys/uio.h>
#include <stdbool.h>

#include "nerveMain.h"

#define ARR_LEN(array)	(sizeof array/ sizeof array[0])

/**
 * convert usec to 'struct timeval'
 */
struct timeval *usec2tv(time_t usec
    , /*@out@*/struct timeval *tv);
    		
int open_cli_sock(const char *srvName, const char *srvPort);
ssize_t readPacket(int d, struct iovec *iovec, bool ntohF, bool readBlkF);
ssize_t writePacket(int d, uint32_t seq, uint16_t pri, uint16_t cat
    , uint16_t flg, uint16_t datLen
    , /*@out@*//*@null@*/void *dat, bool htonF);
size_t rs485_make_packet(/*@out@*/u_char *pcmdbuf
    , u_char id, u_char flag
    , u_char address, u_char length, u_char count
    , /*@null@*/const u_char *pdata);
int rs485_make_long_packet(u_char *pcmdbuf, u_char flag, u_char address
    , u_char length, u_char count, const u_char *pdata);
uint16_t set485devShort(/*@out@*/u_char dst[sizeof(short)], uint16_t src);
uint16_t get485devShort(u_char src[sizeof(short)]);
#endif	//__LIBUTIL_H__
