/*-
 * Copyright (C) 2008 Speecys Corporation
 *		Toshiaki Nozawa <nozawa@speecys.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the Speecys Corporation.
 * 4. Neither the name of The Speecys Corporation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE SPEECYS CORPORATION AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE CORPORATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __LIBSERVO_H__
#define __LIBSERVO_H__

#include <sys/types.h>
#include <stdbool.h>

size_t editSrvRst(u_char id, size_t bufLen, /*@out@*/u_char buf[/*@i@*/bufLen]);
size_t editSrvAng(bool isLong, u_char id, uint16_t angle, uint16_t time
    , size_t bufLen, /*@out@*/u_char buf[bufLen]);
size_t editSrvPwr(bool isLong, u_char id, u_char sw, size_t bufLen
    , /*@out@*/u_char buf[bufLen]);
size_t editSrvCmgn(bool isLong, u_char id, u_char mgn, size_t bufLen
    , /*@out@*/u_char buf[bufLen]);
size_t editSrvCslp(bool isLong, u_char id, u_char mgn, size_t bufLen
    , /*@out@*/u_char buf[bufLen]);
size_t editSrvPunch(bool isLong, u_char id, uint16_t pnc, size_t bufLen
    , /*@out@*/u_char buf[bufLen]);
size_t editSrvParams(bool isLong, u_char id, u_char mgn, u_char slp, u_short pnc
    , size_t bufLen, /*@out@*/u_char buf[bufLen]);
size_t editSrvTrq(bool isLong, u_char id, u_char trq, size_t bufLen
    , /*@out@*/u_char buf[bufLen]);

size_t editPwmSrvAng(u_char id, short angle, u_short time,
    size_t bufLen, /*@out@*/u_char buf[bufLen]);

#endif	//__LIBSERVO_H__
