/*
 * Decompiled with CFR 0.152.
 */
package net.black_cow.opennip.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.black_cow.opennip.opennipcore.NipStone;
import net.black_cow.opennip.opennipcore.NipStrategy;
import net.black_cow.opennip.opennipcore.NipTable;
import net.black_cow.opennip.opennipcore.NipTableUtil;
import net.black_cow.util.TreeElement;

public class MixStrategy
implements NipStrategy {
    private Random rand = new Random();
    private int[][] map = new int[8][8];
    private int depth;
    private long waitTime;

    public MixStrategy(int depth, long waitTime) {
        this.depth = depth;
        this.waitTime = waitTime;
        int i = 2;
        while (i <= 5) {
            this.map[0][i] = 20;
            this.map[1][i] = -5;
            this.map[6][i] = -5;
            this.map[7][i] = 20;
            this.map[i][0] = 20;
            this.map[i][1] = -5;
            this.map[i][6] = -5;
            this.map[i][7] = 20;
            ++i;
        }
        i = 3;
        while (i <= 4) {
            this.map[2][i] = 3;
            this.map[3][i] = 0;
            this.map[4][i] = 0;
            this.map[5][i] = 3;
            this.map[i][2] = 3;
            this.map[i][5] = 3;
            ++i;
        }
        this.map[6][6] = 20;
        this.map[1][6] = 20;
        this.map[6][1] = 20;
        this.map[1][1] = 20;
        this.map[5][5] = -2;
        this.map[2][5] = -2;
        this.map[5][2] = -2;
        this.map[2][2] = -2;
    }

    @Override
    public int[] decide(NipTable table, NipStone stone) {
        int[] decision = this.isMiddlePhase(NipTableUtil.getStoneCount(table, null)) ? this.executeMiddlePhaseStrategy(table, stone) : this.executeLastPhaseStrategy(table, stone);
        try {
            Thread.sleep(this.waitTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return decision;
    }

    private boolean isMiddlePhase(int restCellCount) {
        return restCellCount > 5;
    }

    private int[] executeMiddlePhaseStrategy(NipTable table, NipStone stone) {
        List<int[]> list = NipTableUtil.getCanPutStoneCellList(table, stone);
        ArrayList<int[]> bestWays = new ArrayList<int[]>();
        int bestScore = -10000;
        for (int[] index : list) {
            NipTable state = NipTableUtil.ifYouPutStoneAt(table, index[0], index[1], stone);
            int score = this.evaluateState(state, stone) + this.evaluateNumOfAltanatives(state, stone);
            if (score > bestScore) {
                bestWays.clear();
                bestWays.add(index);
                bestScore = score;
                continue;
            }
            if (score != bestScore) continue;
            bestWays.add(index);
        }
        return (int[])bestWays.get(this.rand.nextInt(bestWays.size()));
    }

    private int[] executeLastPhaseStrategy(NipTable table, NipStone stone) {
        TreeElement<State> e = new TreeElement<State>(new State(table, stone));
        this.serch(e, this.depth, stone.getColor());
        ArrayList<int[]> bestWays = new ArrayList<int[]>();
        int bestScore = -2;
        TreeElement<State>[] treeElementArray = e.getChildren();
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeElement<State> child = treeElementArray[n2];
            if (child.getValue().score > bestScore) {
                bestWays.clear();
                bestWays.add(child.getValue().hand);
                bestScore = child.getValue().score;
            } else if (child.getValue().score == bestScore) {
                bestWays.add(child.getValue().hand);
            }
            ++n2;
        }
        return (int[])bestWays.get(this.rand.nextInt(bestWays.size()));
    }

    private int evaluateState(NipTable table, NipStone stone) {
        return NipTableUtil.evaluate(table, stone.getColor(), this.map);
    }

    private int evaluateNumOfAltanatives(NipTable table, NipStone stone) {
        int value;
        int numOfAltanatives = NipTableUtil.getCanPutStoneCellCount(table, NipTableUtil.differentColorStone(stone));
        switch (numOfAltanatives) {
            case 0: {
                value = 100;
                break;
            }
            case 1: {
                value = 20;
                break;
            }
            case 2: {
                value = 10;
                break;
            }
            default: {
                value = 0;
            }
        }
        return value;
    }

    private void serch(TreeElement<State> parent, int depth, NipStone.Color color) {
        if (depth == 0) {
            return;
        }
        State state = parent.getValue();
        List<int[]> possibilities = NipTableUtil.getCanPutStoneCellList(state.table, state.stone);
        if (possibilities.size() == 0) {
            possibilities = NipTableUtil.getCanPutStoneCellList(state.table, NipTableUtil.differentColorStone(state.stone));
            if (possibilities.size() == 0) {
                return;
            }
            state.stone = NipTableUtil.differentColorStone(state.stone);
        }
        for (int[] possibility : possibilities) {
            NipTable table = NipTableUtil.ifYouPutStoneAt(state.table, possibility[0], possibility[1], state.stone);
            TreeElement<State> e = new TreeElement<State>(new State(table, NipTableUtil.differentColorStone(state.stone)));
            e.getValue().hand = possibility;
            parent.addChild(e);
            this.serch(e, depth - 1, color);
            if (!e.hasChildren()) {
                this.evaluate(e, color);
                continue;
            }
            if (color.equals((Object)e.getValue().stone.getColor())) {
                this.max(e);
                continue;
            }
            this.min(e);
        }
    }

    private void evaluate(TreeElement<State> e, NipStone.Color color) {
        int blank = NipTableUtil.getStoneCount(e.getValue().table, null);
        int score = NipTableUtil.getStoneCount(e.getValue().table, color);
        int otherScore = 52 - blank - score;
        if (NipTableUtil.isFinished(e.getValue().table)) {
            if (score > otherScore) {
                e.getValue().score = 52;
            } else if (score == otherScore) {
                e.getValue().score = 0;
            } else {
                e.getValue().score = -1;
            }
            return;
        }
        e.getValue().score = NipTableUtil.getStoneCount(e.getValue().table, color);
    }

    private void max(TreeElement<State> e) {
        int maxScore = -2;
        TreeElement<State>[] treeElementArray = e.getChildren();
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeElement<State> child = treeElementArray[n2];
            if (child.getValue().score > maxScore) {
                maxScore = child.getValue().score;
            }
            ++n2;
        }
        e.getValue().score = maxScore;
    }

    private void min(TreeElement<State> e) {
        int minScore = 53;
        TreeElement<State>[] treeElementArray = e.getChildren();
        int n = treeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeElement<State> child = treeElementArray[n2];
            if (child.getValue().score < minScore) {
                minScore = child.getValue().score;
            }
            ++n2;
        }
        e.getValue().score = minScore;
    }

    private class State {
        private NipTable table;
        private NipStone stone;
        private int score;
        private int[] hand;

        private State(NipTable table, NipStone stone) {
            this.table = table;
            this.stone = stone;
        }
    }
}

