<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<script src="http://maps.google.com/maps/api/js?sensor=false"><!-- --></script>

	<script>
		// 初期化
		var scale	= Number("{@SCALE}");
		var mapTypeId = google.maps.MapTypeId.ROADMAP;
		var directionsDisplay = new google.maps.DirectionsRenderer();
		var directionsService = new google.maps.DirectionsService();

		var map;

		function initialize()
		{
			var myOptions =
			{
		//		zoom: scale,					// 自動的に範囲が入るように調整される。
				mapTypeId: mapTypeId
			};
			// MAP情報の生成
			map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
			//	directionsDisplay = new google.maps.DirectionsRenderer();
			directionsDisplay.setMap(map);
			// ﾙｰﾄ情報の生成
			directionsDisplay.setPanel(document.getElementById("directionsPanel2"));

			calcRoute();
		}

		function calcRoute()
		{
			var mode;
			if("{@WAY}" == "1"){
				mode = google.maps.DirectionsTravelMode.DRIVING;	// 車
			}else{
				mode = google.maps.DirectionsTravelMode.WALKING;	// 徒歩
			}

			var request =
			{
				origin: "{@FROM}",
				destination: "{@TO}",
				travelMode: mode,										// ドライビングモード指定
				unitSystem: google.maps.DirectionsUnitSystem.METRIC,	// 単位km表示
				optimizeWaypoints: true,								// 最適化された最短距離にする。
				avoidHighways: {@KOSOKU},								// trueで高速道路を使用しない
				avoidTolls: {@YURYO}									// trueで有料道路を使用しない
			};

			// ﾙｰﾄ計算
			directionsService.route(request, function(response, status)
			{
				if (status == google.maps.DirectionsStatus.OK)
				{
					directionsDisplay.setDirections(response);
				}
			});
		}

		// window.onload=initialize;
		window.addEventListener('load', initialize, false);			// 8.3.0.0 (2022/08/01)
	</script>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "TEST09"
	title	= "Mapﾙｰﾄ"
	date	= "2015/09/05"
	author	= "Takahashi Masakazu"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<div style="width:900px">
<!-- 地図 -->
<div id="map_canvas" style="float:left; left:30px; top:30px; width:500px;height:500px"><!-- --></div>
<!-- ﾙｰﾄ計算 -->
<div id="directionsPanel2" style="float:right; width:300px; height:500px;"><!-- --></div>
</div>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>

