<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ENAMEの一覧が必要 C_KEYSがｶﾗﾑ一覧で、C_VALSは縦持ちﾃﾞｰﾀを横持ちｶﾗﾑとして与えるためのﾀﾞﾐｰｶﾗﾑ列 -->
<og:value command="SQL" action="ROW_APPEND" dbid="{@DBID}" >
	select	 ENAME as C_KEYS
			,''''' as ' || ENAME as C_VALS
	from	EMP
	order by ENAME
</og:value>

<!-- ﾃﾞｰﾀは使いませんが、tableModelは必須 -->
<og:query command="NEW" quotCheck="false">
	SELECT '' as ENAME , {@C_VALS} from DUAL
</og:query>

<og:jsChart
	chartType		= "line"
	labelColumn		= "ENAME"
	xscaleType		= "realtime"
	height			= "{@height}"
	width			= "{@width}"
	minLabelWidth	= "{@minLabelWidth}"
	title			= "{@chartTitle}"
	optAxis			= "realtime:RT"
	optOptions		= "tooltips:{mode:'nearest',intersect:false},hover:{mode:'nearest',intersect:false}"
	debug			= "{@debug}"
>
	var RT = {
		frameRate:	30,
		duration:	30000,
		refresh:	5000,
		delay:		5000,
		onRefresh: function(chart) {
			updatechart( chart );
		}
	};

	<c:forTokens items="${C_KEYS}" delims="," var="C_KEY" >
		<og:jsChartData
			chartColumn	= "{@C_KEY}"
			label		= "{@C_KEY}"
			fill		= "false"
			beginAtZero	= "true"
			borderWidth	= "1"
		/>
	</c:forTokens>
</og:jsChart>

<!-- 8.4.1.1 (2023/02/24) headタグ内に移動できないので、title="no_header"追加 -->
<script title="no_header">
	var updatechart = function(_chart){
		if( _chart ) {
			$.ajax({
				url: 'sample14A_ajax.jsp',
				async: true, // 非同期通信
				type: 'GET',
				data: {'ENAME': 'KING'},
				dataType: 'json',
				success: function(jsn){
					for(var i=0; i&lt; jsn.DATA.length; i++){
						_chart.data.datasets[i].data.push({
							x: Date.now(),
							y: jsn.DATA[i].SALES
						});
					}
					_chart.update();
				},
				error: function(err){
					$('#err').html(err.responseText);
				}
			});
		}
	}
</script>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
