<jsp:directive.page pageEncoding="UTF-8" />

<og:query command="NEW" stopZero="{@stopZero}">
	SELECT 	 ENAME
			,ROUND( SAL * DBMS_RANDOM.VALUE ) as SAL1
			,SAL as BASE
			FROM EMP
			<og:where>
				<og:and value="DEPTNO = {@SOOUID}" />
				<og:and value="rownum < 4" />
			</og:where>
</og:query>

<fieldset class="FIELD" >
	<legend>JavaScript</legend>
	<canvas id="mycanvas" style="width:400px; height:400px;"><!-- --></canvas>
	<div class="METER_TXT"><og:value command="GETTBL" action="FIRST" key="SAL1" /></div>
</fieldset>

<!-- 8.4.1.1 (2023/02/24) headタグ内に移動できないので、title="no_header"追加 -->
<script title="no_header">
	// jsonで取得
	var querydata =
	<og:view
		viewFormType	= "JSON"
		command			= "NEW"
		useHilightRow	= "false"
		useAfterHtmlTag	= "false"
		useConsistency	= "false"
		pageSize		= "0" />
	;

	var datadata1   = [];
	var datadata2   = [];
	var datalabels = [];
	for(var i=0; i < querydata.DATA.length; i++){
		datadata1[i]  = querydata.DATA[i].SAL1;
		datadata2[i]  = querydata.DATA[i].BASE;
		datalabels[i] = querydata.DATA[i].ENAME;
	}

	var chartdata = {
		labels: datalabels,
		datasets: [{
			data: datadata1,
			backgroundColor: [ "PINK","Transparent","Transparent" ],
			borderWidth: 0
		},{
			data: datadata2,
			backgroundColor: [ "#FF6384","#FFCE56","#36A2EB" ],
			borderWidth: 0
		}],
	};

	<og:text>
	var myChart = new Chart( mycanvas,{
					type: 'doughnut',
					data: chartdata,
					options: {
						cutout : '70%' ,			// 円は、0% , ドーナツは、50% が初期値
						responsive: false ,
						animation : false ,			// false にしないと、Chart.plugins.register で、２回呼ばれる。
						plugins:{
							legend:{display:false,},
						},
					}
				});
	</og:text>
</script>

<fieldset class="FIELD" >
	<legend>jsChart</legend>
	<og:jsChart
		chartType		= "doughnut"
		labelColumn		= "ENAME"
		optOptions		= "animation:false,cutout:'70%'"
		optTicks		= "color:'black'"
		legendDisplay	= "false"
	>
		<og:jsChartData
			chartColumn		= "SAL1"
			backgroundColor	= "PINK,Transparent,Transparent"
			fontColor		= "black"
			borderWidth		= "0"
		/>
		<og:jsChartData
			chartColumn		= "BASE"
			backgroundColor	= "#FF6384,#FFCE56,#36A2EB"
			borderWidth		= "0"
		/>
	</og:jsChart>
	<div class="METER_TXT"><og:value command="GETTBL" action="FIRST" key="SAL1" /></div>
</fieldset>
