<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7220"
	title	= "ﾄﾞﾗｯｸﾞ情報登録"
	date	= "2015/09/14"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- 配置図/座席表 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		SELECT SYSTEM_ID , LOC_GRP, LOC_KEY , LOC_COL, LOC_ROW, R_KEY1, R_KEY2, R_KEY3,
				NAME_JA, LABEL_NAME, BIKO, ICON, FGJ, UNIQ
		FROM GE18
	<og:where>
		<og:and value="SYSTEM_ID	=    '{@SYSTEM_ID}'"	/>
		<og:and value="LOC_GRP		like '{@LOC_GRP}'"		/>
		<og:and value="LOC_KEY		like '{@LOC_KEY}'"		/>
		<og:and value="NAME_JA		like '{@NAME_JA}'"		/>
		<og:and value="LABEL_NAME	like '{@LABEL_NAME}'"	/>
		<og:and value="BIKO			like '{@BIKO}'"			/>
		<og:and value="R_KEY1		like '{@R_KEY1}'"		/>
		<og:and value="R_KEY2		like '{@R_KEY2}'"		/>
		<og:and value="R_KEY3		like '{@R_KEY3}'"		/>
	</og:where>
		ORDER BY SYSTEM_ID,LOC_GRP, NAME_JA,R_KEY1,R_KEY2,R_KEY3
</og:query>

<og:viewMarker command="{@command}">
	<!-- 決め打ちに近い。LOC_GRP 単位にフォルダを作成してアイコンを保管している -->
	<og:columnMarker column="ICON" caseKey="{@LOC_GRP}" caseVal="オーケストラ">
		<img src="../GF7221/image/[LOC_GRP]/[ICON]" style="width:50px;" title="[LABEL_NAME] [R_KEY2] [R_KEY2] [R_KEY3]" />
	</og:columnMarker>
</og:viewMarker>
<br/>

<!-- ２重押し防止 oneClick()関数は、useAjaxSubmit='true' 使用時には使えません。 -->
<form method="POST" action="forward.jsp" target="RESULT" >
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="null"		/>
		<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,LOC_GRP,LOC_KEY,UNIQ"	/>
		<og:submit  action="DELETE"  columnWritable="null"	/>
	<br />
	</og:writeCheck>

	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		noDisplay  = "FGJ,UNIQ"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
