<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6450"
	title	= "JSON"
	date	= "2012/08/17"
	author	= "A.SANPEI"
	text	= ""
	version	= "001"
>
	YYYY/MM/DD	XXXXX
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />

<!-- データチェック -->
<og:equals val1="{@CDTAN}" notNull="true" >
	<og:dataCheck command="{@command}" lbl="GFE0003" lblParamKeys="{#GF44},{@CDTAN}">
		select count(*) from GF44 where USERID = '{@CDTAN}'
	</og:dataCheck>
</og:equals>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<!-- は不要です-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		SELECT	(CASE KBSAKU WHEN '0' THEN 0 ELSE 1 END) AS WRITABLE	<!-- 書込制御 -->
				,SYSTEM_ID												<!-- ｼｽﾃﾑID -->
				,LANG													<!-- 言語 -->
				,CLM													<!-- 項目 -->
				,NAME_JA												<!-- 名称(漢字) -->
				,LABEL_NAME												<!-- 表示名称 -->
				,KBSAKU													<!-- 作成区分 -->
				,CDTAN													<!-- 担当者 -->
				,UNIQ													<!-- (非表示)ﾕﾆｰｸ -->
				,''	as	PUP												<!-- ﾎﾟｯﾌﾟｱｯﾌﾟﾎﾞﾀﾝ -->
		FROM	GF41
	<og:where>
		<og:and value = "FGJ		IN		('0','1')"			/>	<!-- GF41》状態F    IN   ('0','1') -->
		<og:and value = "SYSTEM_ID	=		'{@SYSTEM_ID}'"		/>	<!-- GF41》ｼｽﾃﾑID   ＝   画面》ｼｽﾃﾑID-->
		<og:and value = "LANG		=		'{@LANG}'"			/>	<!-- GF41》言語     ＝   画面》言語-->
		<og:and value = "CLM		LIKE	'{@CLM}%'"			/>	<!-- GF41》項目     LIKE 画面》項目-->
		<og:and value = "LABEL_NAME	LIKE	'{@LABEL_NAME}%'"	/>	<!-- GF41》表示名称 LIKE 画面》表示名称 -->
		<og:and value = "KBSAKU		=		'{@KBSAKU}'" 		/>	<!-- GF41》作成区分 ＝   画面》作成区分 -->
		<og:and value = "CDTAN		=		'{@CDTAN}'" 		/>	<!-- GF41》担当者   ＝   画面》担当者 -->
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<og:value key="jsonReturn">
	<og:view
		viewFormType	= "{@FormType}"
		command			= "{@command}"
		noDisplay		= "UNIQ"
		useHilightRow	= "false"
		useAfterHtmlTag	= "false"
		useConsistency	= "false"
		useParam		= "true"
	>
		<og:jsonParam
			useHead="false"
			dataName="JSON_DATA"
		/>
	</og:view>
</og:value>

<!-- 改行や空白はそのまま、自動改行 → pre-wrap -->
<div style="white-space: pre-wrap;" id="view" >
	<og:text>{@jsonReturn}</og:text>
</div>

<og:equals val1="{@FORMAT}" val2="1">
	<!-- 8.4.1.1 (2023/02/24) headタグ内に移動できないので、title="no_header"追加 -->
	<script title="no_header">
		const view = document.getElementById("view");
		const jsonV = JSON.stringify(<og:text>{@jsonReturn}</og:text>,null,2);
	//	const jsonV = JSON.stringify(view.textContent);		// なぜか動かない。
		view.textContent = jsonV ;
	</script>
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
