<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6130"
	title	= "左右分割ｽｸﾛｰﾙ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- forward.jsp から command がセットされて遷移してきます。 -->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}" >
	<!-- action には、DEFAULT,CLEAR,ADD,LOWER,UPPER,COPY,SET,NULLSET,TBLSET が指定できます。 -->
	<og:columnSet command="COPY" columnId="CLM" action="NULLSET" value="{@MEM.CLM}"/>
	<og:columnSet command="COPY" columnId="LABEL_NAME" action="TBLSET" value="[NAME_JA]"
					conditionKey="LABEL_NAME" conditionList=""
	/>
	<og:columnSet command="MODIFY" columnId="LABEL_NAME" action="TBLSET" value="[NAME_JA]"
					conditionKey="LABEL_NAME" conditionList=""
	/>
</og:entry>

<og:message command="{@command}" /><br />

<form method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンと、EXCEL(CSV)変更リンクを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。 -->
<og:writeCheck>
	<og:submit action="ENTRY" />
	<og:submit action="RESET" />
	<og:input type="reset" name="command" lbl="MSG0011" td="false" />
	<br />
</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<og:splitView fixDisplay="CLM,NAME_JA" useSplit="{@useSplit}" >
	<og:view
		viewFormType	= "HTMLTable"
		command			= "{@command}"
		checked			= "{@checked}"
		startNo			= "{@startNo}"
		pageSize		= "{@pageSize}"
		noWritable		= "{@noWritable}"
		columnWritable	= "{@columnWritable}"
	/>
</og:splitView>

<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
