/********************************************************************************/
/* chartOptions.js																*/
/*																				*/
/* Chart.js に､ﾗﾍﾞﾙや値の表示を行う､plugins や､onClick で使用できる				*/
/* 関数を定義します｡															*/
/*																				*/
/* @og.rev 6.9.9.2 (2018/09/18) 新規作成										*/
/********************************************************************************/

/********************************************************************************/
/* chartLabelPlugin																*/
/*																				*/
/* jsChart ﾁｬｰﾄﾀｸﾞのｸﾞﾗﾌに値を表示する plugins です｡							*/
/*																				*/
/* <og:jsChart																	*/
/*	  chartType = "bar" 														*/
/*	  plugins	= "chartLabelPlugin"											*/
/*	  ････																		*/
/*																				*/
/* すべてのﾁｬｰﾄに適用させる場合は､register 登録します｡							*/
/*	※ 便宜的に､chartTypeが､polarArea/pie/doughnut の場合は､ﾗﾍﾞﾙと値を			*/
/*		それ以外は､値のみ表示するように処理を入れています｡						*/
/*		また､文字の色は､黒のみで､円ｸﾞﾗﾌの背景色が濃い場合は､					*/
/*		見えにくくなるため､円ｸﾞﾗﾌの背景色で調整してください｡					*/
/*																				*/
/*	<script type="text/javascript"> 											*/
/*		Chart.plugins.register( chartLabelPlugin );								*/
/*	</script>																	*/
/*																				*/
/* Define a plugin to provide data labels										*/
/* https://beiznotes.org/data-label-on-chart-js/								*/
/*																				*/
/* @og.rev 6.9.9.2 (2018/09/18) 新規作成										*/
/* @og.rev 8.0.0.0 (2021/08/20) bubble/scatter 対応								*/
/********************************************************************************/
var chartLabelPlugin = { afterDatasetsDraw: function(chart,options) {
	var ctx = chart.ctx;
	// Draw the text in black, with the specified font
	ctx.fillStyle = 'rgb(0, 0, 0)';

	var fontSize   = 12;
	var fontStyle  = 'normal';
	var fontFamily = 'Helvetica Neue';
	ctx.font = Chart.helpers.fontString(fontSize, fontStyle, fontFamily);

	// Make sure alignment settings are correct
	ctx.textAlign    = 'center';
	ctx.textBaseline = 'bottom';

	var padding = 2;
	var lblOffset =  padding + fontSize;										// 'bottom'
	var valOffset =  padding;													// 'bottom'

	var items = chart.legend.legendItems ;										// 凡例のｵﾌﾞｼﾞｪｸﾄ

	chart.data.datasets.forEach(function(dataset, no) {							// no:ｸﾞﾗﾌ番号
		var meta = chart.getDatasetMeta(no);
		var chtype = chart.config.type.toString();								// 8.0.0.0 (2021/08/20) ﾀｲﾌﾟ判定を何度も行うので｡
		var hideType = "polarArea/pie/doughnut".indexOf( chtype ) < 0 ;			// true:no使用 false:idx使用

		if( hideType ) {														// polarArea/pie/doughnut 以外は､no で判定
			if( items[no].hidden ) { return; }									// 凡例をｸﾘｯｸして非表示にしたときの対応(continueの事)
		}

		meta.data.forEach(function(element, idx) {								// index:data番号
			if( !hideType ) {													// polarArea/pie/doughnut は､idx で判定
				if( items[idx].hidden ) { return; }								// 凡例をｸﾘｯｸして非表示にしたときの対応(continueの事)
			}

			var val = dataset.data[idx];										// 8.0.0.0 (2021/08/20) val を先に求めておく
			if( val ) {															// null(undefine)ﾁｪｯｸ
				var pos = element.tooltipPosition();
				// ﾗﾍﾞﾙ表示
				if( "polarArea/pie/doughnut/bubble/scatter".indexOf( chtype ) >= 0 ) {
					var lbl = chart.data.labels[idx];
					ctx.fillText( lbl , pos.x, pos.y - lblOffset );
				}

				// 値取得
				// 8.0.0.0 (2021/08/20) val を場合分けして処理する｡
				if( "bubble" == chtype ) {
					val = val.r;
		//			var val = [ val.x , val.y , val.r ];
				}
				else if( "scatter" == chtype ) {
		//			val = val.y;
					var val = [ val.x , val.y ];
				}
		//		else {
		//			val = dataset.data[idx].toString();
		//		}

				// 値が数値の場合､ｶﾝﾏ区切り
				if( $.isNumeric(val) ) {
					val = Number(val).toLocaleString( undefined, { maximumFractionDigits: 20 });
				}

				// 値表示
				ctx.fillText( val , pos.x, pos.y - valOffset );
			}
		});
	});
}};

/********************************************************************************/
/* clickLink																	*/
/*																				*/
/* ｸﾞﾗﾌｸﾘｯｸ時に呼び出す､画面を遷移するための処理です｡							*/
/*																				*/
/* <og:jsChart																	*/
/*	  chartType = "bar" 														*/
/*	  onClick	= "clickLink( event, obj , 										*/
/*				'index.jsp?chartTitle={LBL}&amp;markValues={CLM}',parent );"	*/
/*	  labelColumn = "LABELS"													*/
/*	  ････																		*/
/* >																			*/
/*	  <og:jsChartData															*/
/*		  chartColumn = "SAL"													*/
/*		  ････																	*/
/*	  />																		*/
/*																				*/
/* 第３引数に､location.href で遷移させる ｱﾄﾞﾚｽを記入します｡						*/
/* その際､{LBL} に､jsChart の labelColumn で指定した値が､{CLM} に､				*/
/* jsChartData の chartColumn で指定した値が､ｾｯﾄされます｡						*/
/* jsChartData が､複数ある場合は､ｸﾘｯｸしたｸﾞﾗﾌの値が指定されます｡				*/
/*																				*/
/* ちなみに､現時点では､ajax で動的に変更したDATAは､反映しません｡				*/
/*																				*/
/* @og.rev 6.9.9.2 (2018/09/18) 新規作成										*/
/* @og.rev 6.9.9.4 (2018/10/01) ﾃﾞｰﾀの持ち方変更								*/
/* @og.rev 7.0.1.2 (2018/11/04) CLM,VAL,IDXとを変数にencodeURI 対応				*/
/* @og.rev 8.0.0.0 (2021/08/20) V3 対応											*/
/********************************************************************************/
// 棒ｸﾞﾗﾌｸﾘｯｸ時に呼び出されて､画面を遷移するための処理です｡
// ﾘﾝｸは､{LBL} と､{CLM} が､ﾗﾍﾞﾙとｸﾞﾗﾌのﾃﾞｰﾀに置き換えられます｡
// var clickLink = function( event,obj,link,frame ){
// 	if( !frame ) { frame = this; }											// frame で､_top , parent 等指定可能｡
//
// 	if( obj[0] ) {
// 		var idx = obj[0].index;
// 		var sel = obj[0].datasetIndex;										// ｸﾞﾗﾌの番号
// 		var clm = event.chart.data.labels[idx];
// 		var val = event.chart.data.datasets[sel].data[idx];					// ｸﾞﾗﾌのﾃﾞｰﾀ
//
// 		var html = link.replace(/\{CLM\}/g,clm ).replace(/\{VAL\}/g,val ).replace(/\{IDX\}/g,idx );
//
// 		// 画面遷移
// 		frame.location.href = encodeURI( html );
// 	}
// };

/********************************************************************************/
/* chartLink																	*/
/* ﾁｬｰﾄｸﾘｯｸ時に呼び出されて､画面を遷移します｡ 									*/
/*																				*/
/*	  画面IDの有無によるﾀｰｹﾞｯﾄ自動振り分け										*/
/*	  $LBL,$VAL,$IDX,$SEL 記号によるｸﾘｯｸ情報の指定								*/
/*	  外部指定の配列ﾃﾞｰﾀを引数に追加可能(1件のみ)								*/
/*																				*/
/* <og:jsChartV3																*/
/*	  chartType		= "bar"														*/
/*	  labelColumn	= "ENAME"													*/
/*	  onClick		= "chartLink( ①event, ②obj, ③null, ④'result.jsp',		*/
/*								⑤{@JSONDATA}, ⑥'EMPNO', ⑦EMPNO );"			*/
/*	  varColumns	= "EMPNO"													*/
/*	  ････																		*/
/* >																			*/
/*	  <og:jsChartDataV3 														*/
/*		  chartColumn = "SAL1"													*/
/*		  ････																	*/
/*	  />																		*/
/*																				*/
/* 第1引数：ﾌﾞﾗｳｻﾞｲﾍﾞﾝﾄを定義													*/
/* 第2引数：ﾁｬｰﾄのｵﾌﾞｼﾞｪｸﾄを定義												*/
/* 第3引数：ﾘﾝｸ先の画面IDを指定(null,空文字列の場合は自分自身)					*/
/*			gamenId ⇒ ../gamenId/url を生成し､parent ﾀｰｹﾞｯﾄに遷移する			*/
/* 第4引数：ﾘﾝｸ先のURLを指定 													*/
/* 第5引数：ﾘﾝｸ先に渡すJsonｵﾌﾞｼﾞｪｸﾄ形式のﾊﾟﾗﾒｰﾀを指定							*/
/* 第6引数：ﾘﾝｸ先に渡すﾁｬｰﾄｶﾗﾑを指定(下記配列のｷｰ文字列)						*/
/* 第7引数：ﾁｬｰﾄのconstの配列変数を指定(jsChartV3#varColumnsで指定)				*/
/*																				*/
/* @og.rev 8.1.0.4 (2022/01/28) 新規作成										*/
/* @author LEE.M																*/
/********************************************************************************/
const chartLink = function( event, obj, gamenId, url, jsonData, chrtClm, chrtVarAry ) {
	if( obj.length && obj[0] ) {
		const obj0 = obj[0];
		const idx  = obj0.index;											// ﾎﾟｲﾝﾄ位置

		let jsonPrm = {};													// 空のJSONｵﾌﾞｼﾞｪｸﾄ生成

		// 第5引数:ﾘﾝｸ先に渡す引数(jsonData)をﾏｰｼﾞします｡
		Object.assign( jsonPrm,jsonData );

		// 第6引数,第7引数:ﾘﾝｸ先に渡すﾁｬｰﾄｶﾗﾑと配列変数の値を指定します｡
		if( chrtClm && chrtVarAry && Array.isArray( chrtVarAry ) ) {
			jsonPrm[chrtClm] = chrtVarAry[idx];								// JSONｵﾌﾞｼﾞｪｸﾄに追加
		}

		// ｸﾘｯｸされた､$LBL,$VAL,$IDX,$SEL を変換します｡
		const sel   = obj0.datasetIndex;									// $LBL:ｸﾞﾗﾌ番号
		const data  = event.chart.data;										// $VAL:ﾃﾞｰﾀ
		const dtLbl = data.labels[idx];										// $IDX:ﾃﾞｰﾀﾗﾍﾞﾙ
		const dtVal = data.datasets[sel].data[idx];							// $SEL:ﾃﾞｰﾀ値

		// 先に JSON⇒URL引数変換すると､URLｴﾝｺｰﾄﾞ されてしまうので､一旦文字列化します｡
		let jsonStr = JSON.stringify( jsonPrm );
		jsonStr = jsonStr.replace("$LBL",dtLbl)
						 .replace("$VAL",dtVal)
						 .replace("$IDX",idx)
						 .replace("$SEL",sel);

		// JSON文字列から､JSONｵﾌﾞｼﾞｪｸﾄに戻す｡
		jsonPrm = JSON.parse( jsonStr );
		// JSONｵﾌﾞｼﾞｪｸﾄからURLｴﾝｺｰﾄﾞ済みのURLﾊﾟﾗﾒｰﾀを生成する｡
		let strUrl = new URLSearchParams( jsonPrm ).toString();

		// 第3引数:画面IDの有無で､ﾍﾟｰｼﾞ遷移のtargetを区別します｡
		if( gamenId == null || gamenId == '' ) {
			window.location.href = url + "?" + strUrl;
		} else {
			window.parent.location.href = '../' + gamenId + '/' + url + "?" + strUrl;
		}
	}
};
