<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJSV3="true" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
左のチャートをクリックする事で、右のチャートのデータをajax経由で持ってきて更新します。


<!-- onClick のURLの引数チェック -->
<og:text>
  <table>
	<tr><td>chartTitle</td><td>=</td><td>{@chartTitle}</td></tr>
	<tr><td>markValues</td><td>=</td><td>{@markValues}</td></tr>
	<tr><td>sample</td><td>=</td><td>{@sample}</td></tr>
  </table>
</og:text>

	<!-- ﾁｬｰﾄ情報の取得 -->
	<og:query>
		SELECT DEPTNO
				,DNAME LABELS
				,(select sum(SAL) from emp where emp.deptno = dept.deptno) SAL
		FROM DEPT
		order by 1
	</og:query>

<!--
	<script>
		// Chart.plugins.register で、登録すると、すべてのチャートに適用されます。
		Chart.plugins.register( chartLabelPin );
	</script>
-->
<div style="float:left;">
	<og:jsChartV3
		id					= "MainChart"
		chartType			= "pie"
		height				= "{@height}"
		width				= "{@width}"
		labelColumn			= "LABELS"
		title				= "{@chartTitle}"
		plugins				= "chartLabelPlugin"
		onClick				= "updatechart(event,obj,'SubChart')"
		debug				= "{@debug}"
	>
		<og:jsChartDataV3
			chartColumn			= "SAL"
		 />
	</og:jsChartV3>
</div>
	<!-- ﾁｬｰﾄ情報の取得 -->
	<og:query scope="request" tableId="tbl2">
		SELECT JOB    as LABELS
			,sum(SAL) as SAL , max(EMPNO) as EMPNO , max(ENAME) as ENAME
		FROM emp
		group by job
		order by 1
	</og:query>

<!-- oota tmp modify onClick属性から、
 qb_hybscanvastbl2で選択したグラフの情報が取得可能です。
 (id設定時はqb+id。idが未設定の場合は自動設定。)
 ※データ以外をクリック時も呼ばれるため、if文で制御しています。
 ※ver6ではラベル名とデータのみが保持されており、利用可能です。
  -->
 <!-- console.log(qd_hybscanvastbl2.DATA);console.log(obj[0]._index);if(obj[0]){clickLink(qd_hybscanvastbl2.DATA[obj[0]._index]);} -->

	<og:jsChartV3
		id					= "SubChart"
		chartType			= "bar"
		height				= "{@height}"
		width				= "{@width}"
		labelColumn			= "LABELS"
		legendDisplay		= "false"
		optOptions			= ""
		onClick				= "clickLink(event,obj,'index.jsp?chartTitle={LBL}&amp;markValues={CLM}&amp;sample=sample5&amp;command=NEW',parent);"
		plugins				= "chartLabelPlugin"
		scope				= "request"
		tableId				= "tbl2"
		debug				= "{@debug}"
	>
		<og:jsChartDataV3
			chartColumn			= "SAL"
			max					= "10000"
			min					= "{@min}"
		 />
		<og:jsChartDataV3
			chartColumn			= "EMPNO"
		 />
	</og:jsChartV3>

<!-- エラー確認用 -->
エラー時の情報:
<div id="err"></div>

<script>
	// 左の円形を選択時に、右の棒グラフを更新します。
	// ※ラベル名を利用しているため、重複したラベル名が存在する場合、正しく動作しません。
	var updatechart = function(event,obj,tgtId){
		// チャートの空白箇所クリック時の処理
//alert( Object.keys(event));	// type,chart,native,x,y,offsetX,offsetY
//alert( Object.keys(obj[0]));	// element,datasetIndex,index
		if( obj[0] ) {
			// ver6ではラベル名と値のみ保持しており、利用可能です。
			let labelNm = event.chart.data.labels[obj[0].index];
			let chTgt   = eval("chart_" + tgtId);		// アクセス先のオブジェクトを取得

			$.ajax({
				url:'sample5_ajax.jsp',
				async:true, // 非同期通信
				type: 'GET',
				data: {'LABELNM': labelNm},
				dataType: 'json',
				success: function(jsn){
					for(let i=0; i&lt; jsn.DATA.length; i++){
						chTgt.data.datasets[0].data[i]	= jsn.DATA[i].SAL;
						chTgt.data.datasets[1].data[i]	= jsn.DATA[i].EMPNO;
						chTgt.data.labels[i]			= jsn.DATA[i].LABELS;
					}
					// ラベル変更は難しいが、データセットの変更だけなら簡単
					// 新たなラベルが増えるような場合が面倒になる？
					chTgt.update();
				},
				error: function(err){
					$('#err').html(err.responseText);
				}
			});
		}
	};

	// 棒グラフクリック時に呼び出されて、画面を遷移するための処理です。
	// URLは適当です。
	// リンクは、{LBL} と、{CLM} が、ラベルとグラフのデータに置き換えられます。
	var clickLink = function( event,obj,link,frame ){
		if( !frame ) { frame = this; }

		if( obj[0] ) {
			let idx = obj[0].index;
			let sel = obj[0].datasetIndex;							// グラフの番号

			let lbl = event.chart.data.labels[idx];
			let val = event.chart.data.datasets[sel].data[idx];		// グラフのデータ

			let html = link.replace(/\{LBL\}/g,lbl ).replace(/\{CLM\}/g,val );

			alert(html + ' に遷移します。');
			frame.location.href = html;
		}
	};
</script>
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
