<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC03"
	title	= "属性クラス定義"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select  VERNO,ATTCLASS,VALUENAME,ATTKEY
			<og:text caseNN  ="{@TEXT_DATA}">,CTX_DOC.SNIPPET('GF25_TXT_IDX',UNIQ,'{@TEXT_DATA}') AS DESCRIPTION</og:text>
			<og:text caseNull="{@TEXT_DATA}">,DESCRIPTION</og:text>
				,CONTENTS,FORM_SAMPLE
		from    GF25
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "VERNO			=    '{@VERNO}'"		/>
		<og:and value = "ATTKEY			=    '{@ATTKEY}'"		/>
		<og:and value = "VALUENAME		=    '{@VALUENAME}'"	/>
		<og:and value = "DESCRIPTION	LIKE '{@DESCRIPTION}'"	/>
		<og:and value = "CONTENTS		LIKE '{@CONTENTS}'"		/>
		<og:and value = "FGJ			in ( '0','1' )"			/>
		<og:and value = "CONTAINS ( FGJ, '{@TEXT_DATA}' ,1) &gt; 0"	/>
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@ORDER_BY}" defaultVal="VERNO,SEQ,ATTKEY" />
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="VALUENAME" gamenId="DOC03" href="index.jsp" target="CONTENTS"
		keys="command,VERNO,VALUENAME,PRE_FIX,VIEW"
		vals="NEW,[VERNO],[VALUENAME],og," />
	<og:link column="ATTKEY" gamenId="DOC03" href="index.jsp" target="CONTENTS"
		keys="command,VERNO,ATTKEY,VALUENAME,PRE_FIX,VIEW"
		vals="NEW,[VERNO],[ATTKEY],[VALUENAME],og,FULL" />
</og:viewLink>

<!-- VIEW か ATTKEY が、nullでない(入力されたら） 詳細表示を行う。  -->
<og:equals val1="{@VIEW}{@ATTKEY}" nullCheck="true" notEquals="true" >
	<!-- DB検索結果を表示させます。 -->
	<og:view
		viewFormType = "HTMLFormatTable"
		command 	 = "{@command}"
		writable     = "false"
		pageSize     = "{@pageSize}"
		rowspan      = "3"
	>
	<tr><td valign="top">[VERNO]<br />[VALUENAME]<br />[ATTKEY]</td>
		<td valign="top"><pre>[CONTENTS]</pre></td>
	</tr>
	<tr><td colspan="2"><pre>[ATTCLASS]</pre></td></tr>
	<tr><td colspan="2"><pre style="font-family:monospace;">[FORM_SAMPLE]</pre></td></tr>
	</og:view>
</og:equals>

<!-- VIEW も ATTKEY も、nullの場合は、一覧表示を行う。  -->
<og:equals val1="{@VIEW}{@ATTKEY}" nullCheck="true" >
<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	noDisplay	 = "ATTCLASS,CONTENTS,FORM_SAMPLE"
	columnGroup	 = "VALUENAME,ATTKEY"
	groupClass	 = "--"
	writable     = "false"
	pageSize     = "{@pageSize}" />
</og:equals>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
