/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.StringUtil;

public final class JSONScan
implements Iterator<String> {
    private static final String CR = HybsConst.CR;
    private static final int BUFFER_MIDDLE = 200;
    private final String orgStr;
    private final char stCh;
    private final char edCh;
    private final int stScan;
    private final int edScan;
    private int stAdrs;
    private int edAdrs;

    public JSONScan(String string, char c, char c2) {
        this(string, c, c2, 0, string.length());
    }

    public JSONScan(String string, char c, char c2, int n, int n2) {
        this.orgStr = string;
        this.stCh = c;
        this.edCh = c2;
        this.stScan = n;
        this.edScan = n2;
        this.stAdrs = 0;
        this.edAdrs = n;
    }

    @Override
    public boolean hasNext() {
        this.stAdrs = this.orgStr.indexOf(this.stCh, this.edAdrs);
        if (this.stAdrs < 0 || this.stAdrs > this.edScan) {
            return false;
        }
        this.edAdrs = this.orgStr.indexOf(this.edCh, this.stAdrs + 1);
        return this.edAdrs >= 0 && this.edAdrs <= this.edScan;
    }

    @Override
    public String next() {
        return this.orgStr.substring(this.stAdrs + 1, this.edAdrs);
    }

    public int countBlock() {
        String string = this.orgStr.substring(this.stScan, this.edScan);
        long l = string.chars().filter(n -> n == this.stCh).count();
        return Math.toIntExact(l);
    }

    public static Map<String, String> json2Map(String string) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray = StringUtil.csv2Array(string)) {
            String[] stringArray2 = string2.split(":", 2);
            if (stringArray2.length != 2) continue;
            hashMap.put(JSONScan.json2Trim(stringArray2[0]), JSONScan.json2Trim(stringArray2[1]));
        }
        return hashMap;
    }

    public static String map2Json(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder(200);
        if (map != null) {
            int n = 0;
            stringBuilder.append('{').append(CR);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (n == 0) {
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append(",\"");
                }
                ++n;
                stringBuilder.append(entry.getKey()).append("\":\"").append(entry.getValue()).append('\"').append(CR);
            }
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public static String[] json2Array(String string) {
        String[] stringArray = StringUtil.csv2Array(string);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "null".equals(stringArray[i]) ? "" : JSONScan.json2Trim(stringArray[i]);
        }
        return stringArray;
    }

    private static String json2Trim(String string) {
        char c;
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && ((c = string.charAt(n)) == '\"' || c == '{' || c == '}' || c == ' '); ++n) {
        }
        while (n < n2 && ((c = string.charAt(n2 - 1)) == '\"' || c == '{' || c == '}' || c == ' ')) {
            --n2;
        }
        return n < n2 ? string.substring(n, n2) : "";
    }
}

