/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.system;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.system.ThrowUtil;

public final class LogWriter {
    private static PrintWriter writer;
    private static String encode;
    private static final Object LOCK;
    private static String logFileUrl;

    private LogWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String string, String string2) {
        Object object = LOCK;
        synchronized (object) {
            LogWriter.close();
            logFileUrl = string;
            encode = string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String string) {
        Object object = LOCK;
        synchronized (object) {
            if (writer == null) {
                writer = LogWriter.getPrintWriter();
            }
        }
        writer.println("[WriteTime= " + DateSet.getDate("yyyy/MM/dd HH:mm:ss.SSS") + "] " + string);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Throwable throwable) {
        Object object = LOCK;
        synchronized (object) {
            if (writer == null) {
                writer = LogWriter.getPrintWriter();
            }
        }
        writer.println(ThrowUtil.ogStackTrace(throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Object object = LOCK;
        synchronized (object) {
            if (writer != null) {
                writer.close();
            }
            writer = null;
        }
    }

    private static PrintWriter getPrintWriter() {
        if (logFileUrl == null || logFileUrl.isEmpty()) {
            return new PrintWriter(System.err);
        }
        DateSet dateSet = new DateSet();
        String string = dateSet.changeString(logFileUrl);
        try {
            File file = new File(string);
            if (encode == null || encode.isEmpty()) {
                return new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
            }
            return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), encode)));
        }
        catch (IOException iOException) {
            String string2 = "\u30ed\u30b0\u30e9\u30a4\u30bf\u30fc\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
            throw new OgRuntimeException(string2, iOException);
        }
    }

    static {
        LOCK = new Object();
    }
}

