/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.ColumnData;

final class ColumnDataLoader {
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String QUERY = "select CLM,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,LABEL_CLM,CODE_CLM,CLM_PARAM,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,ROLES,'' AS FIELD_SIZE,FGLOAD,UNIQ,SYSTEM_ID,KBSAKU from GEA03 where SYSTEM_ID=? and FGJ='1' order by KBSAKU,CLM";
    private static final String QUERY2 = "select CLM,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,LABEL_CLM,CODE_CLM,CLM_PARAM,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,ROLES,'' AS FIELD_SIZE,FGLOAD,UNIQ,SYSTEM_ID,KBSAKU from GEA03 where SYSTEM_ID=? and CLM=? and FGJ='1' order by KBSAKU DESC";
    private static final boolean IS_FGLOAD_AUTOSET = HybsSystem.sysBool("USE_FGLOAD_AUTOSET");
    private static final String UPDATE2 = "update GEA03 set FGLOAD='2' where UNIQ=? and CLM=?";
    private final Map<String, ColumnData> columnMap = Collections.synchronizedMap(new WeakHashMap());
    private final String[] SYS_ARRAY;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    ColumnDataLoader(String[] stringArray, boolean bl) {
        this.SYS_ARRAY = stringArray;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYS_ARRAY[0], HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ColumnDataLoader", null, null);
        } else {
            this.appInfo = null;
        }
        if (bl) {
            this.loadDBResource();
        }
    }

    private void loadDBResource() {
        int n = this.SYS_ARRAY.length;
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            String string = this.SYS_ARRAY[i];
            String[] stringArray = new String[]{string};
            String[][] stringArray2 = DBUtil.dbExecute((String)QUERY, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
            int n3 = stringArray2.length;
            n2 += n3;
            for (int j = 0; j < n3; ++j) {
                String string2 = stringArray2[j][0];
                if ("1".equals(stringArray2[j][16])) {
                    this.columnMap.put(string2, new ColumnData(stringArray2[j]));
                    int n4 = i;
                    nArray[n4] = nArray[n4] + 1;
                    continue;
                }
                if (this.columnMap.get(string2) == null) continue;
                this.columnMap.remove(string2);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("  ").append(this.SYS_ARRAY[0]).append("  ColumnDataLoader [").append(n2).append("] Map=[").append(this.columnMap.size()).append("] ");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.SYS_ARRAY[i]).append("=[").append(nArray[i]).append("] ");
        }
        stringBuilder.append("loaded.");
        System.out.println(stringBuilder);
    }

    public ColumnData getColumnData(String string) {
        ColumnData columnData = this.columnMap.get(string);
        if (columnData == null) {
            for (String string2 : this.SYS_ARRAY) {
                String[] stringArray = new String[]{string2, string};
                String[][] stringArray2 = DBUtil.dbExecute((String)QUERY2, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
                if (stringArray2.length <= 0) continue;
                columnData = new ColumnData(stringArray2[0]);
                this.columnMap.put(string, columnData);
                if (!IS_FGLOAD_AUTOSET) break;
                String string3 = stringArray2[0][16];
                String string4 = stringArray2[0][18];
                if ("1".equals(string3) || "2".equals(string3) || "**".equals(string4)) break;
                String[] stringArray3 = new String[]{stringArray2[0][17], string};
                DBUtil.dbExecute((String)UPDATE2, (String[])stringArray3, (ApplicationInfo)this.appInfo, (String)this.DBID);
                break;
            }
        }
        return columnData;
    }

    public void clear(String string) {
        System.out.println("SYSTEM_ID=[" + this.SYS_ARRAY[0] + "] , Key=[" + string + "] \u306e\u90e8\u5206\u30ea\u30bd\u30fc\u30b9\u30af\u30ea\u30a2\u3092\u5b9f\u65bd\u3057\u307e\u3057\u305f\u3002");
        this.columnMap.remove(string);
    }

    public void clear() {
        System.out.println("SYSTEM_ID=[" + this.SYS_ARRAY[0] + "] \u306e\u5168\u30ea\u30bd\u30fc\u30b9\u3092\u30af\u30ea\u30a2\u3057\u307e\u3057\u305f\u3002");
        this.columnMap.clear();
    }
}

