/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.column;

import java.text.DecimalFormat;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;

public class Editor_DECIMAL
extends AbstractEditor {
    private static final String VERSION = "7.4.2.3 (2021/06/09)";
    private static final String[] FRMT = new String[]{"#,##0", "#,##0.0", "#,##0.00", "#,##0.000", "#,##0.0000", "#,##0.00000", "#,##0.000000"};
    private final int minFraction;
    private final DecimalFormat format;
    private final String defValue;

    public Editor_DECIMAL() {
        this.minFraction = 0;
        this.format = null;
        this.defValue = null;
    }

    private Editor_DECIMAL(DBColumn dBColumn) {
        super(dBColumn);
        this.minFraction = dBColumn.getSizeY();
        String string = this.makeFormat(dBColumn);
        this.format = new DecimalFormat(string);
        String string2 = dBColumn.getDefault();
        if (string2 == null || string2.isEmpty()) {
            this.defValue = "";
        } else {
            double d = 0.0;
            if (!"_".equals(string2)) {
                d = StringUtil.parseDouble((String)string2);
            }
            this.defValue = this.format.format(d);
        }
        int n = (int)((double)dBColumn.getSizeX() * 4.0 / 3.0) + this.minFraction + 2;
        this.attributes.set("maxlength", String.valueOf(n));
        this.tagBuffer.add(XHTMLTag.inputAttri((Attributes)this.attributes));
    }

    private String makeFormat(DBColumn dBColumn) {
        String string = dBColumn.getEditorParam();
        if (string == null || string.isEmpty() || string.equals("_")) {
            int n;
            string = "#,##0.##";
            String string2 = dBColumn.getViewLength();
            if (string2 != null && (n = string2.indexOf(46)) >= 0) {
                String string3 = string2.substring(n + 1);
                try {
                    int n2 = Integer.parseInt(string3);
                    string = n2 < FRMT.length ? FRMT[n2] : FRMT[FRMT.length - 1];
                }
                catch (Throwable throwable) {
                    String string4 = "\u8868\u793a\u6841\u6570\u306e\u5c0f\u6570\u90e8\u306e\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + CR + "viewLen=" + string2 + CR + throwable.getMessage();
                    System.err.println(string4);
                }
            }
        }
        return string;
    }

    public CellEditor newInstance(DBColumn dBColumn) {
        return new Editor_DECIMAL(dBColumn);
    }

    public String getValue(String string) {
        return super.getValue(this.formatValue(string));
    }

    public String getValue(int n, String string) {
        return super.getValue(n, this.formatValue(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatValue(String string) {
        String string2;
        if (string == null || string.trim().isEmpty() || "0".equals(string)) {
            return this.defValue;
        }
        double d = StringUtil.parseDouble((String)string);
        DecimalFormat decimalFormat = this.format;
        synchronized (decimalFormat) {
            string2 = this.format.format(d);
        }
        return string2;
    }
}

