/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jdbc.FirebirdDatabaseMetaData;
import org.firebirdsql.jdbc.GeneratedKeysSupport;
import org.firebirdsql.jdbc.QuoteStrategy;
import org.firebirdsql.jdbc.metadata.MetadataPattern;
import org.firebirdsql.jdbc.parser.JaybirdStatementModel;
import org.firebirdsql.jdbc.parser.StatementParser;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

final class GeneratedKeysQueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(GeneratedKeysQueryBuilder.class);
    private static final GeneratedKeysSupport.QueryType[] statementTypeToQueryType;
    private static final int IDX_COLUMN_NAME = 4;
    private static final int IDX_ORDINAL_POSITION = 17;
    private final String originalSql;
    private final JaybirdStatementModel statementModel;
    private final Set<GeneratedKeysSupport.QueryType> supportedQueryTypes;

    private GeneratedKeysQueryBuilder(String originalSql, JaybirdStatementModel statementModel, Set<GeneratedKeysSupport.QueryType> supportedQueryTypes) {
        this.originalSql = originalSql;
        this.statementModel = statementModel;
        this.supportedQueryTypes = supportedQueryTypes;
    }

    private GeneratedKeysQueryBuilder(String originalSql) {
        this(originalSql, null, Collections.emptySet());
    }

    static GeneratedKeysQueryBuilder create(StatementParser parser, String statementText, Set<GeneratedKeysSupport.QueryType> supportedQueryTypes) {
        try {
            JaybirdStatementModel statementModel = parser.parseStatement(statementText);
            return new GeneratedKeysQueryBuilder(statementText, statementModel, supportedQueryTypes);
        }
        catch (StatementParser.ParseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception parsing query: " + statementText, e);
            }
            return new GeneratedKeysQueryBuilder(statementText);
        }
    }

    boolean isSupportedType() {
        if (this.statementModel == null) {
            return false;
        }
        int statementType = this.statementModel.getStatementType();
        try {
            GeneratedKeysSupport.QueryType queryType = statementTypeToQueryType[statementType];
            return this.supportedQueryTypes.contains((Object)queryType);
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug("Unsupported or incorrectly defined statement type: " + statementType);
            return false;
        }
    }

    GeneratedKeysSupport.Query forNoGeneratedKeysOption() {
        if (this.hasReturning()) {
            return new GeneratedKeysSupport.Query(true, this.originalSql);
        }
        return new GeneratedKeysSupport.Query(false, this.originalSql);
    }

    GeneratedKeysSupport.Query forReturnGeneratedKeysOption(FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.hasReturning()) {
            return new GeneratedKeysSupport.Query(true, this.originalSql);
        }
        if (this.isSupportedType()) {
            if (this.supportsReturningAll(databaseMetaData)) {
                return this.useReturningAll();
            }
            return this.useReturningAllColumnsByName(databaseMetaData);
        }
        return new GeneratedKeysSupport.Query(false, this.originalSql);
    }

    private boolean supportsReturningAll(FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.getDatabaseMajorVersion() >= 4;
    }

    private GeneratedKeysSupport.Query useReturningAll() {
        return this.addColumnsByNameImpl(Collections.singletonList("*"), QuoteStrategy.NO_QUOTES);
    }

    private GeneratedKeysSupport.Query useReturningAllColumnsByName(FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        List<String> columnNames = this.getAllColumnNames(this.statementModel.getTableName(), databaseMetaData);
        QuoteStrategy quoteStrategy = QuoteStrategy.forDialect(databaseMetaData.getConnectionDialect());
        return this.addColumnsByNameImpl(columnNames, quoteStrategy);
    }

    private boolean hasReturning() {
        return this.statementModel != null && this.statementModel.hasReturning();
    }

    GeneratedKeysSupport.Query forColumnsByIndex(int[] columnIndexes, FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        if (this.hasReturning()) {
            return new GeneratedKeysSupport.Query(true, this.originalSql);
        }
        if (columnIndexes == null || columnIndexes.length == 0) {
            throw FbExceptionBuilder.forException(337248290).messageParameter("columnIndexes").toFlatSQLException();
        }
        if (this.isSupportedType()) {
            List<String> columnNames = this.getColumnNames(this.statementModel.getTableName(), columnIndexes, databaseMetaData);
            QuoteStrategy quoteStrategy = QuoteStrategy.forDialect(databaseMetaData.getConnectionDialect());
            return this.addColumnsByNameImpl(columnNames, quoteStrategy);
        }
        return new GeneratedKeysSupport.Query(false, this.originalSql);
    }

    GeneratedKeysSupport.Query forColumnsByName(String[] columnNames) throws SQLException {
        if (this.hasReturning()) {
            return new GeneratedKeysSupport.Query(true, this.originalSql);
        }
        if (columnNames == null || columnNames.length == 0) {
            throw FbExceptionBuilder.forException(337248290).messageParameter("columnNames").toFlatSQLException();
        }
        if (this.isSupportedType()) {
            return this.addColumnsByNameImpl(Arrays.asList(columnNames), QuoteStrategy.NO_QUOTES);
        }
        return new GeneratedKeysSupport.Query(false, this.originalSql);
    }

    private GeneratedKeysSupport.Query addColumnsByNameImpl(List<String> columnNames, QuoteStrategy quoteStrategy) {
        assert (columnNames != null && !columnNames.isEmpty()) : "Column names are required";
        StringBuilder returningQuery = new StringBuilder(this.originalSql);
        for (int idx = returningQuery.length() - 1; idx >= 0; --idx) {
            char currentChar = returningQuery.charAt(idx);
            if (currentChar == ';') {
                returningQuery.setLength(idx);
                break;
            }
            if (Character.isWhitespace(currentChar)) continue;
            returningQuery.setLength(idx + 1);
            break;
        }
        returningQuery.append('\n').append("RETURNING ");
        for (String columnName : columnNames) {
            quoteStrategy.appendQuoted(columnName, returningQuery).append(',');
        }
        returningQuery.setLength(returningQuery.length() - 1);
        return new GeneratedKeysSupport.Query(true, returningQuery.toString());
    }

    private List<String> getAllColumnNames(String tableName, FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        try (ResultSet rs = databaseMetaData.getColumns(null, null, this.normalizeObjectName(tableName), null);){
            if (rs.next()) {
                ArrayList<String> columns = new ArrayList<String>();
                do {
                    columns.add(rs.getString(4));
                } while (rs.next());
                ArrayList<String> arrayList = columns;
                return arrayList;
            }
            throw FbExceptionBuilder.forException(337248292).messageParameter(tableName).toFlatSQLException();
        }
    }

    private List<String> getColumnNames(String tableName, int[] columnIndexes, FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        Map<Integer, String> columnByIndex = this.mapColumnNamesByIndex(tableName, columnIndexes, databaseMetaData);
        ArrayList<String> columns = new ArrayList<String>(columnIndexes.length);
        for (int indexToAdd : columnIndexes) {
            String columnName = columnByIndex.get(indexToAdd);
            if (columnName == null) {
                throw new FbExceptionBuilder().nonTransientException(337248291).messageParameter(indexToAdd).messageParameter(tableName).toFlatSQLException();
            }
            columns.add(columnName);
        }
        return columns;
    }

    private Map<Integer, String> mapColumnNamesByIndex(String tableName, int[] columnIndexes, FirebirdDatabaseMetaData databaseMetaData) throws SQLException {
        try (ResultSet rs = databaseMetaData.getColumns(null, null, this.normalizeObjectName(tableName), null);){
            if (!rs.next()) {
                throw new FbExceptionBuilder().nonTransientException(337248292).messageParameter(tableName).toFlatSQLException();
            }
            HashMap<Integer, String> columnByIndex = new HashMap<Integer, String>();
            int[] sortedIndexes = (int[])columnIndexes.clone();
            Arrays.sort(sortedIndexes);
            do {
                int columnPosition;
                if (Arrays.binarySearch(sortedIndexes, columnPosition = rs.getInt(17)) < 0) continue;
                columnByIndex.put(columnPosition, rs.getString(4));
            } while (rs.next());
            HashMap<Integer, String> hashMap = columnByIndex;
            return hashMap;
        }
    }

    private String normalizeObjectName(String objectName) {
        if (objectName == null) {
            return null;
        }
        objectName = objectName.trim();
        if ((objectName = MetadataPattern.escapeWildcards(objectName)).length() > 2 && objectName.charAt(0) == '\"' && objectName.charAt(objectName.length() - 1) == '\"') {
            return objectName.substring(1, objectName.length() - 1).replaceAll("\"\"", "\"");
        }
        return objectName.toUpperCase();
    }

    static {
        GeneratedKeysSupport.QueryType[] temp = new GeneratedKeysSupport.QueryType[7];
        Arrays.fill((Object[])temp, (Object)GeneratedKeysSupport.QueryType.UNSUPPORTED);
        temp[1] = GeneratedKeysSupport.QueryType.INSERT;
        temp[2] = GeneratedKeysSupport.QueryType.UPDATE;
        temp[3] = GeneratedKeysSupport.QueryType.DELETE;
        temp[4] = GeneratedKeysSupport.QueryType.UPDATE_OR_INSERT;
        temp[6] = GeneratedKeysSupport.QueryType.MERGE;
        statementTypeToQueryType = temp;
    }
}

