/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.argument;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.impl.argument.Argument;
import org.firebirdsql.gds.impl.argument.ArgumentType;

public final class StringArgument
extends Argument {
    private static final EnumSet<ArgumentType> SUPPORTED_ARGUMENT_TYPES = EnumSet.of(ArgumentType.TraditionalDpb, ArgumentType.Wide, ArgumentType.StringSpb);
    private final String value;
    private final byte[] asBytes;
    private final Encoding encoding;
    private final ArgumentType argumentType;

    @Deprecated
    public StringArgument(int type, ArgumentType argumentType, String value) {
        this(type, argumentType, value, EncodingFactory.getPlatformEncoding());
    }

    public StringArgument(int type, ArgumentType argumentType, String value, Encoding encoding) {
        super(type);
        if (!SUPPORTED_ARGUMENT_TYPES.contains((Object)argumentType)) {
            throw new IllegalArgumentException("Invalid argument type: " + argumentType);
        }
        this.argumentType = argumentType;
        if (encoding == null) {
            throw new IllegalArgumentException("Encoding is required");
        }
        if (value == null) {
            throw new IllegalArgumentException("String value should not be null");
        }
        this.value = value;
        this.asBytes = encoding.encodeToCharset(value);
        this.encoding = encoding;
        if (this.asBytes.length > argumentType.getMaxLength()) {
            throw new IllegalArgumentException(String.format("byte array derived from String value should not be longer than %d bytes, length was %d", argumentType.getMaxLength(), this.asBytes.length));
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
        this.argumentType.writeLength(this.asBytes.length, outputStream);
        outputStream.write(this.asBytes);
    }

    @Override
    public int getLength() {
        return 1 + this.argumentType.getLengthSize() + this.asBytes.length;
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    @Override
    public int getValueAsInt() {
        return Integer.parseInt(this.value);
    }

    @Override
    public void copyTo(ParameterBuffer buffer, Encoding stringEncoding) {
        buffer.addArgument(this.getType(), this.value, stringEncoding != null ? stringEncoding : this.encoding);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof StringArgument)) {
            return false;
        }
        StringArgument otherStringArgument = (StringArgument)other;
        return this.getType() == otherStringArgument.getType() && this.value.equals(otherStringArgument.value);
    }
}

