/**
 * <p>このドキュメントは、バッチフレームワーク『ふくろう』の ＡＰＩ 仕様です。</p>
 * <pre>
 * ２．基本設計
 *   （２）機能概要説明
 *     ３．バッチ処理フレームワーク
 *       【概要】
 *           大量データの登録や抜き出しなど、バッチ的な処理を行うフレームワークを作成します。
 *           このフレームワークに、基本機能の実装と、各種システム固有機能の実装が簡単に
 *           行えるように、プラグイン方式を採用します。
 *           なお、このフレームワーク単独での採用は検討していません。エンジンとしては、
 *           一体として扱います。
 * 
 *       【効果】
 *           簡易的なバッチ（あるDBから抜き出して、別のDBに登録するなど）や、ファイルからの
 *           入出力などが、簡単に作成できるようになります。
 *           将来的には、統合サーバー機能を充実させることで、PL/SQLの代わりにJavaで
 *           業務アプリケーションを作成していく事が可能になります。
 * 
 *       【機能】
 *           １．バッチ共通のMainProcess で、各Process クラス を数珠繋ぎに処理していきます。
 *           ２．処理の開始は、FirstProcess クラスより始めて、順次、ChainProcess実装クラスで
 *               処理を継続します。
 *           ３．FirstProcess クラス の next() で、次の行が存在するかどうかを判断します。
 *               以降の ChainProcess では、LineModel が null かどうか判断して、継続処理を行うか
 *               どうかを決定します。
 *           ４．MainProcess の拡張機能(ログ方式など）をサブクラスで与えます。
 * 
 *    org.opengion.fukurou.process (classes)
 *       → org.opengion.fukurou.db                            classes
 *       → org.opengion.fukurou.mail                          classes
 *       → org.opengion.fukurou.model                         classes
 *       → org.opengion.fukurou.security                      classes
 *       → org.opengion.fukurou.system                        classes
 *       → org.opengion.fukurou.util                          classes
 *       → org.opengion.fukurou.xml                           classes
 * </pre>
 * <img src="fukurou001.gif" alt="バッチ処理フレームワーク『ふくろう』"  >
 */
package org.opengion.fukurou.process;
