/****************************************************************************/
/* GE12 ( ｼｽﾃﾑﾊﾟﾗﾒｰﾀ定義 )                                                  */
/*                                                                          */
/* Created : 2020/12/16 08:13:51                                            */
/****************************************************************************/

CREATE TABLE GE12 (
   SYSTEM_ID    VARCHAR2 (  10 )                        NOT NULL            /*  10 ｼｽﾃﾑID       */
 , PARAM_ID     VARCHAR2 (  50 )                        NOT NULL            /*  20 ﾊﾟﾗﾒｰﾀID     */
 , SEQNO        NUMBER   (   7 )        DEFAULT 0       NOT NULL            /*  30 表示順       */
 , TITLE        VARCHAR2 ( 300 )                                            /*  40 ﾀｲﾄﾙ         */
 , PARAM        VARCHAR2 ( 500 )                                            /*  50 設定値       */
 , CONTENTS     CLOB                                                        /*  60 内容         */
 , PARAM_LVL    VARCHAR2 (   1 )        DEFAULT '5'     NOT NULL            /*  70 設定ﾚﾍﾞﾙ     */
 , KBSAKU       VARCHAR2 (   1 )        DEFAULT '1'     NOT NULL            /*  80 作成区分     */
 , FGCRYPT      VARCHAR2 (   1 )        DEFAULT '0'     NOT NULL            /*  90 暗号化ﾌﾗｸﾞ   */
 , CONTXT_PATH  VARCHAR2 (  50 )        DEFAULT '**'    NOT NULL            /* 100 ｺﾝﾃｷｽﾄﾊﾟｽ    */
 , FGREBOOT     VARCHAR2 (   1 )        DEFAULT '0'                         /* 110 要再起動ﾌﾗｸﾞ */
 , UNIQ         NUMBER   (   9 )        DEFAULT 0       NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (   1 )        DEFAULT '1'     NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (  14 )                                            /* 820 作成日時     */
 , PGSET        VARCHAR2 (  10 )                                            /* 830 作成PG       */
 , PGPSET       VARCHAR2 (  10 )                                            /* 840 作成親PG     */
 , USRSET       VARCHAR2 (  10 )                                            /* 850 作成者       */
 , DYUPD        VARCHAR2 (  14 )                                            /* 860 更新日時     */
 , PGUPD        VARCHAR2 (  10 )                                            /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (  10 )                                            /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (  10 )                                            /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );


CREATE SEQUENCE GE12S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE12T00 
  BEFORE INSERT ON GE12
  FOR EACH ROW 
  BEGIN 
    SELECT GE12S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
