/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opengion.fukurou.fileexec.CommandLine;
import org.opengion.fukurou.fileexec.FileExec;
import org.opengion.fukurou.fileexec.StringUtil;
import org.opengion.fukurou.fileexec.XLogger;
import org.opengion.fukurou.system.HybsConst;

public final class MainProcess
implements Runnable {
    private static final XLogger LOGGER = XLogger.getLogger(MainProcess.class.getSimpleName());
    public static final long WAIT_TIME = 30000L;
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(5);
    private static final Set<ScheduledFuture<?>> FUTURE_SET = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final AtomicBoolean IS_START = new AtomicBoolean();
    private static MainProcess mainPrcs;
    private static final Object STATIC_LOCK;
    private final ConcurrentMap<String, FileExec> execMap = new ConcurrentHashMap<String, FileExec>();
    private int cnt;

    private MainProcess() {
        LOGGER.info(() -> "MainProcess Start! ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainProcess getInstance() {
        Object object = STATIC_LOCK;
        synchronized (object) {
            if (mainPrcs == null) {
                mainPrcs = new MainProcess();
            }
        }
        return mainPrcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        block5: {
            try {
                MainProcess mainProcess;
                if (!FUTURE_SET.isEmpty()) break block5;
                Object object = STATIC_LOCK;
                synchronized (object) {
                    mainProcess = MainProcess.getInstance();
                }
                object = HybsConst.getenv("loop");
                long l = object == null || ((String)object).isEmpty() ? 30L : Long.parseLong((String)object);
                FUTURE_SET.add(SCHEDULER.scheduleWithFixedDelay(mainProcess, 0L, l, TimeUnit.SECONDS));
                IS_START.set(true);
            }
            catch (Throwable throwable) {
                LOGGER.warning(throwable, "MSG0021", "MainProcess#start");
                MainProcess.shutdown(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(boolean bl) {
        LOGGER.info(() -> "MainProcess Shutdown Starting ...");
        IS_START.set(false);
        FUTURE_SET.forEach(scheduledFuture -> scheduledFuture.cancel(true));
        FUTURE_SET.clear();
        if (bl) {
            SCHEDULER.shutdownNow();
        }
        Object object = STATIC_LOCK;
        synchronized (object) {
            if (mainPrcs != null) {
                mainPrcs.watchStop();
            }
            mainPrcs = null;
        }
        LOGGER.info(() -> "MainProcess Shutdown Complete.");
    }

    public static boolean isStarted() {
        return IS_START.get();
    }

    private void startTask(CommandLine commandLine) {
        String string = commandLine.getValue(CommandLine.GE70.SYSTEM_ID);
        String string2 = commandLine.getValue(CommandLine.GE70.RSRV_NO);
        String string3 = string + "_" + string2;
        this.stopTask(string3);
        String string4 = commandLine.getValue(CommandLine.GE70.FGYKAN);
        if ("1".equals(string4)) {
            FileExec fileExec = new FileExec(commandLine);
            LOGGER.info(() -> "startTask: yoyakuNo=[" + string3 + "]");
            fileExec.watchStart();
            this.execMap.put(string3, fileExec);
        } else {
            LOGGER.warning(() -> "\u3010WARNING\u3011startTask: yoyakuNo=[" + string3 + "] , fgkan=[" + string4 + "]");
        }
    }

    private void stopTask(String string) {
        FileExec fileExec = (FileExec)this.execMap.remove(string);
        if (fileExec != null) {
            fileExec.watchStop();
        }
        LOGGER.info(() -> "stopTask: yoyakuNo=[" + string + "]");
    }

    public void watchStop() {
        this.execMap.forEach((string, fileExec) -> fileExec.watchStop());
    }

    @Override
    public void run() {
        try {
            List<CommandLine> list = CommandLine.dbCommand();
            list.forEach(commandLine -> this.startTask((CommandLine)commandLine));
            System.out.println(StringUtil.getTimeFormat("yyyy/MM/dd HH:mm:ss [" + this.cnt++ + "]"));
        }
        catch (Throwable throwable) {
            LOGGER.warning(throwable, "MSG0021", "MainProcess#run");
            MainProcess.shutdown(true);
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        STATIC_LOCK = new Object();
    }
}

