/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GFP00030 ( PACKAGE BODY )                                                */
/* Created : 2020/12/16 08:13:53                                            */
/****************************************************************************/

CREATE 
PACKAGE BODY GFP00030 AS
/********************************************************************************
*	システム名	：	エンジンWEBシステム
*	JOB名		：	メール送信モジュールバッチ送信SPサンプル
*	JOBID		：	GFP00030
*	作成日		：	2009/03/12
*	作成者		：	S.Li
*	更新日		：
*	備考		：
********************************************************************************/
/********************************************************************************
*	Declare Package-Body
********************************************************************************/
PROCEDURE GFP00030 (
	PI_SYSTEM_ID    IN		VARCHAR2,
	PI_PTN_ID       IN		VARCHAR2,
	PI_FROM_ID      IN		VARCHAR2,
	PI_TO_ID        IN		VARCHAR2,
	PI_CC_ID        IN		VARCHAR2,
	PI_BCC_ID       IN		VARCHAR2,
	PI_H_TXT        IN		VARCHAR2,
	PI_F_TXT        IN		VARCHAR2,
	PI_PARAM0       IN		VARCHAR2,
	PI_PARAM1       IN		VARCHAR2,
	PI_PARAM2       IN		VARCHAR2,
	PI_PARAM3       IN		VARCHAR2,
	PI_PARAM4       IN		VARCHAR2,
	PI_PARAM5       IN		VARCHAR2,
	PI_PARAM6       IN		VARCHAR2,
	PI_PARAM7       IN		VARCHAR2,
	PI_PARAM8       IN		VARCHAR2,
	PI_PARAM9       IN		VARCHAR2,
	PI_ATTACH1      IN		VARCHAR2,
	PI_ATTACH2      IN		VARCHAR2,
	PI_ATTACH3      IN		VARCHAR2,
	PI_ATTACH4      IN		VARCHAR2,
	PI_ATTACH5      IN		VARCHAR2,
	PO_STATUS		OUT		NUMBER  ,
	PO_ERR_CODE		OUT		VARCHAR2,
	PO_ERRMSG		OUT		VARCHAR2
)
IS
/********************************************************************************
*	変数定義
********************************************************************************/
	-- 共通変数
	STEP_STATUS		NUMBER			:= 1;
	STEP_ERR_CODE	VARCHAR2(1000)	:= '';
	G_RTN			BOOLEAN			:=	TRUE;
	G_ERRCD			VARCHAR2(10)	:=	NULL;
	G_SQLCODE		VARCHAR2(10)	:=	NULL;
	G_ERRMSG		VARCHAR2(1000);

	G_ERR		EXCEPTION;

	-- SUB-ROUTINGS
	FUNCTION	ERROR_CHECK_SYAIN_RTN(
					 PI_SYAIN_ID			IN		VARCHAR2
					,PO_ERRCD				OUT		VARCHAR2
					,PO_SQLCODE 			OUT 	VARCHAR2
					,PO_ERRMSG 				OUT 	VARCHAR2	)	RETURN BOOLEAN;
	FUNCTION	ERROR_CHECK_GROUP_RTN(
					 PI_SYSTEM_ID			IN		VARCHAR2
					,PI_GROUP_ID			IN		VARCHAR2
					,PO_ERRCD				OUT		VARCHAR2
					,PO_SQLCODE 			OUT 	VARCHAR2
					,PO_ERRMSG 				OUT 	VARCHAR2	)	RETURN BOOLEAN;
	FUNCTION ERROR_CHECK_PATTERN_RTN (
					 PI_SYSTEM_ID			IN		VARCHAR2
					,PI_PTN_ID				IN		VARCHAR2
					,PO_ERRCD				OUT		VARCHAR2
					,PO_SQLCODE				OUT		VARCHAR2
					,PO_ERRMSG				OUT		VARCHAR2	)	RETURN BOOLEAN;
	FUNCTION	ERROR_CHECK_DST_RTN(
					 PI_SYS_ID			IN		VARCHAR2
					,PI_DST_ID				IN		VARCHAR2
					,PO_ERRCD				OUT		VARCHAR2
					,PO_SQLCODE 			OUT 	VARCHAR2
					,PO_ERRMSG 				OUT 	VARCHAR2	)	RETURN BOOLEAN;

/********************************************************************************
*   ERROR_CHECK_SYAIN_RTN         社員IDのﾁｪｯｸを行う                            *
********************************************************************************/
FUNCTION ERROR_CHECK_SYAIN_RTN (
	 PI_SYAIN_ID	IN		VARCHAR2
	,PO_ERRCD		OUT		VARCHAR2
	,PO_SQLCODE		OUT		VARCHAR2
	,PO_ERRMSG		OUT		VARCHAR2
) RETURN BOOLEAN
IS
	L_COUNT	NUMBER;
BEGIN
	SELECT COUNT(*) INTO L_COUNT
	FROM GE35
	WHERE 	USERID = PI_SYAIN_ID ;

	IF L_COUNT > 0 THEN
		RETURN TRUE;
	ELSE
		RETURN FALSE;
	END IF;
EXCEPTION
	WHEN OTHERS THEN
		PO_ERRCD	:=	'ERR';
		PO_SQLCODE	:=	TO_CHAR(SQLCODE);
		PO_ERRMSG	:=	SUBSTRB(SQLERRM, 1, 100);
		RETURN FALSE;
END ERROR_CHECK_SYAIN_RTN;

/********************************************************************************
*   ERROR_CHECK_GROUP_RTN         グループIDのﾁｪｯｸを行う                        *
********************************************************************************/
FUNCTION ERROR_CHECK_GROUP_RTN (
	 PI_SYSTEM_ID	IN		VARCHAR2
	,PI_GROUP_ID	IN		VARCHAR2
	,PO_ERRCD		OUT		VARCHAR2
	,PO_SQLCODE		OUT		VARCHAR2
	,PO_ERRMSG		OUT		VARCHAR2
) RETURN BOOLEAN
IS
	L_COUNT	NUMBER;
BEGIN
	SELECT COUNT(*) INTO L_COUNT
	FROM GE33
	WHERE 	SYSTEM_ID = PI_SYSTEM_ID
		AND	GROUP_ID  = PI_GROUP_ID ;

	IF L_COUNT > 0 THEN
		RETURN TRUE;
	ELSE
		RETURN FALSE;
	END IF;
EXCEPTION
	WHEN OTHERS THEN
		PO_ERRCD	:=	'ERR';
		PO_SQLCODE	:=	TO_CHAR(SQLCODE);
		PO_ERRMSG	:=	SUBSTRB(SQLERRM, 1, 100);
		RETURN FALSE;
END ERROR_CHECK_GROUP_RTN;

/********************************************************************************
*   ERROR_CHECK_PATTERN_RTN         定型文IDのﾁｪｯｸを行う                        *
********************************************************************************/
FUNCTION ERROR_CHECK_PATTERN_RTN (
	 PI_SYSTEM_ID	IN		VARCHAR2
	,PI_PTN_ID		IN		VARCHAR2
	,PO_ERRCD		OUT		VARCHAR2
	,PO_SQLCODE		OUT		VARCHAR2
	,PO_ERRMSG		OUT		VARCHAR2
) RETURN BOOLEAN
IS
	L_COUNT	NUMBER;
BEGIN
	SELECT COUNT(*) INTO L_COUNT
	FROM GE31
	WHERE 	SYSTEM_ID = PI_SYSTEM_ID
		AND	PTN_ID    = PI_PTN_ID ;

	IF L_COUNT > 0 THEN
		RETURN TRUE;
	ELSE
		RETURN FALSE;
	END IF;
EXCEPTION
	WHEN OTHERS THEN
		PO_ERRCD	:=	'ERR';
		PO_SQLCODE	:=	TO_CHAR(SQLCODE);
		PO_ERRMSG	:=	SUBSTRB(SQLERRM, 1, 100);
		RETURN FALSE;
END ERROR_CHECK_PATTERN_RTN;

/********************************************************************************
*   ERROR_CHECK_DST_RTN         宛先IDのﾁｪｯｸを行う                            *
********************************************************************************/
FUNCTION ERROR_CHECK_DST_RTN (
	 PI_SYS_ID		IN		VARCHAR2
	,PI_DST_ID		IN		VARCHAR2
	,PO_ERRCD		OUT		VARCHAR2
	,PO_SQLCODE		OUT		VARCHAR2
	,PO_ERRMSG		OUT		VARCHAR2
) RETURN BOOLEAN
IS
	L_COUNT		NUMBER;
	L_POS		NUMBER;
	L_BUFSTR	VARCHAR2(4000);
	L_ID		VARCHAR2(10);
	L_RTN		BOOLEAN	:=	TRUE;
BEGIN
	L_BUFSTR := PI_DST_ID;
	LOOP
		L_POS := NVL( INSTR( L_BUFSTR, ',' ), 0 );
		IF L_POS > 0 THEN
			L_ID  := SUBSTR( L_BUFSTR ,1 , L_POS-1 );
			L_BUFSTR := SUBSTR( L_BUFSTR ,L_POS+1 , LENGTH( L_BUFSTR )-L_POS );
		ELSE
			L_ID  := L_BUFSTR;
		END IF;

		IF LENGTH( L_ID ) >0 THEN
			IF INSTR( L_ID, 'GP.' ) > 0 THEN
				L_ID  := SUBSTR( L_ID ,4 , LENGTH( L_ID )-3 );
				L_RTN := ERROR_CHECK_GROUP_RTN( PI_SYS_ID, L_ID, PO_ERRCD, PO_SQLCODE, PO_ERRMSG );
			ELSE
				L_RTN := ERROR_CHECK_SYAIN_RTN( L_ID, PO_ERRCD, PO_SQLCODE, PO_ERRMSG );
			END IF;
		END IF;

		IF ( NOT L_RTN ) OR ( L_POS = 0 ) THEN
			EXIT;
		END IF;
	END LOOP;

	RETURN L_RTN;
EXCEPTION
	WHEN OTHERS THEN
		PO_ERRCD	:=	'ERR';
		PO_SQLCODE	:=	TO_CHAR(SQLCODE);
		PO_ERRMSG	:=	SUBSTRB(SQLERRM, 1, 100);
		RETURN FALSE;
END ERROR_CHECK_DST_RTN;

/********************************************************************************
*	メイン処理
********************************************************************************/
BEGIN
/********************************************************************************
*	初期処理
********************************************************************************/
	PO_STATUS	:= 1;
	PO_ERR_CODE	:= '';
	PO_ERRMSG	:= '';

	--定型文IDのチェックを行います。
	G_RTN := ERROR_CHECK_PATTERN_RTN(PI_SYSTEM_ID, PI_PTN_ID, G_ERRCD, G_SQLCODE, G_ERRMSG);
	IF G_RTN = FALSE THEN
		RAISE G_ERR;
	END IF;
	--送信者IDのチェックを行います。
	G_RTN := ERROR_CHECK_SYAIN_RTN(PI_FROM_ID, G_ERRCD, G_SQLCODE, G_ERRMSG);
	IF G_RTN = FALSE THEN
		RAISE G_ERR;
	END IF;
	--宛先（TO）のチェック
	IF PI_TO_ID IS NOT NULL THEN
		G_RTN := ERROR_CHECK_DST_RTN( PI_SYSTEM_ID, PI_TO_ID, G_ERRCD, G_SQLCODE, G_ERRMSG);
		IF G_RTN = FALSE THEN
			RAISE G_ERR;
		END IF;
	END IF;
	--宛先（CC）のチェック
	IF PI_CC_ID IS NOT NULL THEN
		G_RTN := ERROR_CHECK_DST_RTN( PI_SYSTEM_ID, PI_CC_ID, G_ERRCD, G_SQLCODE, G_ERRMSG);
		IF G_RTN = FALSE THEN
			RAISE G_ERR;
		END IF;
	END IF;
	--宛先（BCC）のチェック
	IF PI_BCC_ID IS NOT NULL THEN
		G_RTN := ERROR_CHECK_DST_RTN( PI_SYSTEM_ID, PI_BCC_ID, G_ERRCD, G_SQLCODE, G_ERRMSG);
		IF G_RTN = FALSE THEN
			RAISE G_ERR;
		END IF;
	END IF;
	--パラメータテーブルのINSERT処理。
	INSERT INTO GE30(
		 SYSTEM_ID
		,PTN_ID
		,FGJ
		,FROM_ID
		,TO_ID
		,CC_ID
		,BCC_ID
		,H_TXT
		,F_TXT
		,PARAM0
		,PARAM1
		,PARAM2
		,PARAM3
		,PARAM4
		,PARAM5
		,PARAM6
		,PARAM7
		,PARAM8
		,PARAM9
		,ATTACH1
		,ATTACH2
		,ATTACH3
		,ATTACH4
		,ATTACH5
		,DYSET
		,USRSET
		,PGUPD
	) VALUES(
		 PI_SYSTEM_ID	--システムID
		,PI_PTN_ID		--定型文ID
		,'1'			--状況フラグ：'登録（送信待ち）'
		,PI_FROM_ID		--送信者ID
		,PI_TO_ID		--宛先（TO）
		,PI_CC_ID		--宛先（CC）
		,PI_BCC_ID		--宛先（BCC）
		,PI_H_TXT		--ヘッダー自由文
		,PI_F_TXT		--フッター自由文
		,PI_PARAM0		--パラメータ０
		,PI_PARAM1		--パラメータ１
		,PI_PARAM2		--パラメータ２
		,PI_PARAM3		--パラメータ３
		,PI_PARAM4		--パラメータ４
		,PI_PARAM5		--パラメータ５
		,PI_PARAM6		--パラメータ６
		,PI_PARAM7		--パラメータ７
		,PI_PARAM8		--パラメータ８
		,PI_PARAM9		--パラメータ９
		,PI_ATTACH1		--添付ファイル１
		,PI_ATTACH2		--添付ファイル２
		,PI_ATTACH3		--添付ファイル３
		,PI_ATTACH4		--添付ファイル４
		,PI_ATTACH5		--添付ファイル５
		,TO_CHAR(SYSDATE,'YYYYMMDDHH24MMSS')
		,'BATCH'
		,'GFP00030'
	);

	PO_STATUS :=0;

/********************************************************************************
*	EXCEPTION
********************************************************************************/
EXCEPTION
	WHEN G_ERR THEN
		ROLLBACK;
		PO_STATUS	:= 1;										--ｴﾗｰﾒｯｾｰｼﾞｺｰﾄﾞ
		PO_ERR_CODE := G_SQLCODE;								--ｴﾗｰｺｰﾄﾞ
		PO_ERRMSG	:= G_ERRMSG; 								--ｴﾗｰﾒｯｾｰｼﾞ
		RETURN;
	WHEN OTHERS THEN
		ROLLBACK;
		PO_STATUS   := 1;
		PO_ERR_CODE := 'ORA' || TO_CHAR(SQLCODE, '09999');
		PO_ERRMSG	:= SUBSTRB(G_ERRMSG, 1, 255); 				--ｴﾗｰﾒｯｾｰｼﾞ
		RETURN;

END GFP00030;
END GFP00030;
;
