/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* HYBS ( PACKAGE )                                                         */
/* Created : 2020/12/16 08:14:04                                            */
/****************************************************************************/

CREATE 
PACKAGE HYBS AS
/*****************************************************************************/
/*	はやぶさエラーメッセージ標準関数パッケージ								 */
/*****************************************************************************/

	-- エラーメッセージ最大数オーバー例外
	TOO_MANY_ERRORS		EXCEPTION;

	--共通SPをCallした時に使用する例外(2007/09/28)
	COMMONSP_ERROR		EXCEPTION;

	---------------------------------------------------------------------------
	-- エラーメッセージ配列セット関数
	---------------------------------------------------------------------------
	PROCEDURE SET_ERRMSGS
		(P_ERRMSGS	IN OUT	ERR_MSG_ARRAY,
		 P_NO		IN		NUMBER   := NULL,
		 P_KEKKA	IN		NUMBER	 := NULL,
		 P_ID		IN		VARCHAR2 := NULL,
		 P_MSG1		IN		VARCHAR2 := NULL,
		 P_MSG2		IN		VARCHAR2 := NULL,
		 P_MSG3		IN		VARCHAR2 := NULL,
		 P_MSG4		IN		VARCHAR2 := NULL,
		 P_MSG5		IN		VARCHAR2 := NULL );

	---------------------------------------------------------------------------
	-- エラーメッセージ配列セット関数2 3.8.9.5 (2007/09/29) PG、ステップ名称追加
	---------------------------------------------------------------------------
	PROCEDURE SET_ERRMSGS2
		(P_ERRMSGS	IN OUT	ERR_MSG_ARRAY,
		 P_NO		IN		NUMBER   := NULL,
		 P_KEKKA	IN		NUMBER	 := NULL,
		 P_PG		IN		VARCHAR2 := NULL,
		 P_STEP		IN		VARCHAR2 := NULL,
		 P_ID		IN		VARCHAR2 := NULL,
		 P_MSG1		IN		VARCHAR2 := NULL,
		 P_MSG2		IN		VARCHAR2 := NULL,
		 P_MSG3		IN		VARCHAR2 := NULL,
		 P_MSG4		IN		VARCHAR2 := NULL,
		 P_MSG5		IN		VARCHAR2 := NULL );

	---------------------------------------------------------------------------
	-- エラーメッセージ配列最大値オーバーメッセージセット関数
	---------------------------------------------------------------------------
	PROCEDURE SET_LIMITOVER
		(P_ERRMSGS	IN OUT	ERR_MSG_ARRAY);

	---------------------------------------------------------------------------
	-- 経過時刻セット関数
	---------------------------------------------------------------------------
	PROCEDURE SET_TIMEMSG
		(P_ERRMSGS	IN OUT	ERR_MSG_ARRAY,
		 P_ID		IN		VARCHAR2 := NULL,
		 P_MSG1		IN		VARCHAR2 := NULL );

	---------------------------------------------------------------------------
	-- エラーメッセージ配列出力関数 3.8.9.5 (2007/09/29)
	---------------------------------------------------------------------------
	PROCEDURE OUTPUT_ERRMSGS
		(P_ERRMSGS	IN	ERR_MSG_ARRAY,
		 P_JOBID	IN	VARCHAR2,
		 P_PGNAME	IN	VARCHAR2);

	---------------------------------------------------------------------------
	-- エラーメッセージ配列のステータス最大値取得関数 3.8.9.5 (2007/09/29)
	---------------------------------------------------------------------------
	FUNCTION GET_MAX_KEKKA
		(P_ERRMSGS	IN	ERR_MSG_ARRAY,
		 P_ROWNO	IN	NUMBER := 1
		) RETURN NUMBER; -- 4.3.1.1 (2008/10/08) 検索開始行番号を指定できるように修正

END HYBS;
;
