package org.opengion.plugin.daemon;

import java.util.Date;

import javax.jms.QueueSession;

import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.queue.QueueInfo;
import org.opengion.fukurou.queue.QueueSend;
import org.opengion.fukurou.queue.QueueSendFactory;
import org.opengion.fukurou.util.HybsTimerTask;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.queue.DBAccessQueue;

/**
 * メッセージキュー送信
 * メッセージキュー送信テーブルを監視して、
 * 送信処理を行います。
 * 
 * @og.group メッセージ連携
 *
 * @og.rev 5.10.15.0 (2019/08/30) 新規作成
 * @og.rev 5.10.15.2 (2019/09/20) DB登録の実装をhayabusa.queueに移動
 * 
 * @version 5.0
 * @author oota
 * @since JDK7
 *
 */
public class Daemon_QueueSend extends HybsTimerTask {
	private int loopCnt = 0;
	private static final int LOOP_COUNTER = 24;
	private QueueSend queueSend;

	private String SYSTEM_ID = HybsSystem.sys("SYSTEM_ID");
	private static final String CLOUD_SQS_ACCESS_KEY = HybsSystem.sys( "CLOUD_SQS_ACCESS_KEY" );
	private static final String CLOUD_SQS_SECRET_KEY = HybsSystem.sys( "CLOUD_SQS_SECRET_KEY" );
	private final String USER_ID = "CYYYYY";
	private final String PG_ID = "DMN_QueSnd";
	private final String DMN_NAME = "QueueReceiveDMN";
	private final DBAccessQueue dbAccessQueue;
	
	/**
	 * コンストラクター
	 * 初期処理を行います。
	 */
	public Daemon_QueueSend(){
		dbAccessQueue = new DBAccessQueue(SYSTEM_ID, USER_ID, PG_ID, DMN_NAME);
	}
	/**
	 * 開始処理
	 * 
	 * 
	 * タイマータスクのデーモン処理の開始ポイントです。
	 * 
	 * @og.rev 5.10.16.1 (2019/10/11) StringUtil変更
	 * 
	 */
	@Override
	protected void startDaemon() {
		if (loopCnt % LOOP_COUNTER == 0) {
			loopCnt = 1;
			System.out.println();
			System.out.println(toString() + " " + new Date() + "");
		} else {
			// メッセージキュー送信管理テーブルから、送信対象のレコードを取得
			String[][] vals = dbAccessQueue.selectGE65();
			
			// 取得データ分の繰り返し処理を実行する
			for(int i = 0; i  < vals.length; i++) {
				String[] record = vals[i];
				
				// GE65から取得した値を変数に格納
				String ykno =  record[0];
				String queueId = record[1];
				String message = record[2];
				String dedupliId = record[3];
				String queSyu = record[4];
				String jmsUrl = record[5];
				
				String queueType = queSyu.toUpperCase();
				queueSend = QueueSendFactory.newQueueSend(queueType);
	
				// 接続処理
				queueSend.connect(jmsUrl, CLOUD_SQS_ACCESS_KEY, CLOUD_SQS_SECRET_KEY);
				
				// メッセージ送信管理テーブルから取得したデータを送信実装予定
				QueueInfo queueInfo = new QueueInfo();
				
				// 応答確認種別
				if("MQ".equals(queueType)){
					// MQメッセージサーバ指定時
					queueInfo.setMqTransacted(false);
					queueInfo.setMqAcknowledgeMode(QueueSession.AUTO_ACKNOWLEDGE);
					// キュー名
					queueInfo.setMqQueueName(queueId);
				}else if("SQS".equals(queueType)){
					// SQSメッセージサーバ指定時
					// グループID
					queueInfo.setSqsFifoGroupId(queueId);
//					if(!StringUtil.isEmpty(dedupliId)) {
					if(!StringUtil.isNull(dedupliId)) {	
						// 重複排除ID
						// コンテンツに基づく重複排除が有効時は、未設定でも可(メッセージによる重複判定が行われる)
						queueInfo.setSqsFifoDedupliId(dedupliId);
					}
				}
			
				// メッセージ
				queueInfo.setMessage(message);
			
				// 完了フラグを処理中：２に更新
				dbAccessQueue.updateGE66(ykno, DBAccessQueue.FGKAN_PROCESS);
				
				// メッセージ送信処理
				try{
					queueSend.sendMessage(queueInfo);
					
					// 完了フラグを完了：３に更新
					dbAccessQueue.updateGE66(ykno, DBAccessQueue.FGKAN_END);
					
				}catch(Exception e) {
					// 完了フラグをエラー：４に更新して、エラー情報を登録
					dbAccessQueue.updateGE66Error(ykno, e.getMessage());
				} 
			}
			
			// クローズ処理
			queueSend.close();
			
			loopCnt++;
		}
	}
}
