<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" adjustEvent="Matrix" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7213"
	title	= "マトリクス"
	date	= "2012/05/16"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>


<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>
<!--説明
 行番号、列番号、セル名称、設定値、セル背景色、セル編集可(1)／不可(0)、ステータス
 の順番でSQL文を書いてください。
-->
<og:query command="{@command}" displayMsg="">
	SELECT 	 ROW_ID		
			,COL_ID		
			,CELLNAME	
			,VALUE		
			,COLOR		
			,FGCELLEDIT	
			,CDJ		as	STATUS
	FROM GF46 
	WHERE LOC_ID = 'RD6F'
	ORDER BY ROW_ID,COL_ID
</og:query>

<!-- セルの設定値と背景色の初期値 -->
<og:value key="CELLCOLOR" value="green" />
<og:value key="CELLVALUE" value="PN999" />
<og:columnEditor column="STATUS" renderer="LABEL" />
<og:columnEditor column="FGCELLEDIT" noResource="true" /> <!-- 2017/04/07 ADD 背景色のﾌﾗｸﾞはﾘｿｰｽ変換しない-->
<!-- iMatrix用のデータ出力 -->
<!-- viewFormTypeは必ず HTMLDynamic にしてください。 -->
<og:view
	viewFormType  = "HTMLDynamic"
	useScrollBar  = "false"
	useHilightRow = "false"
	noMessage	  = "true"
	pageSize	  = "10000"
/>
<!-- マトリクス描画 -->
<!--属性説明
	mode	   : Layout レイアウト編集 Value 設定値の編集
	countPro   : viewタグによる出力される行毎のカラム数(SQL文のカラム数(非表示項目を除く))
	inputWidth : 編集時の入力欄幅
	cellWidth  : セル幅
	cellHeight : セル高さ
	showStatus : ステータスの出力をする(true)／しない(false)
	countStatus: ステータスの種類数
	writable   : 画面編集可(true)／編集不可(false)
	paramVal   : "{@CELLVALUE}"
	paramColor : "{@CELLCOLOR}"
-->
	<og:iMatrix 
		mode	  	= "{@mode}" 
		countPro  	= "7"
		inputWidth	= "80px"
		cellWidth 	= "100px"
		cellHeight	= "30px"
		writable	= "{@writable}"
		showStatus 	= "{@showStatus}"
		countStatus	= "6"
		editColor	= "{@editColor}"
		separator	= ":"
	/>

<!-- DB更新のフィードバック
<div id="FEEDBACK" />
-->

<og:view
	viewFormType  = "HTMLTable"
	pageSize	  = "10000"
/>


<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
