<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:mis="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java mis" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <ADDRESS   ><xsl:value-of select="$ADDRESS"   /></ADDRESS>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
  </xsl:param>

  <xsl:template match="jsp:root">
    <xsl:apply-templates select="//mis:column[@name]" />
    <xsl:apply-templates select="//mis:input[@name]"  />
    <xsl:apply-templates select="//mis:select[@name]"   />
    <xsl:apply-templates select="//mis:hidden[@name]"   />
    <xsl:apply-templates select="//mis:textarea[@name]" />
  </xsl:template>

  <xsl:template match="mis:*[@name]">
     <xsl:if test="@name = translate( @name,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
         <ROW>
           <xsl:copy-of select="$row_header" />
           <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
           <FORM_TYPE   ><xsl:value-of select="@type"      /></FORM_TYPE>
           <NAME        ><xsl:value-of select="@name"      /></NAME>
           <VALUE       ><xsl:value-of select="@value"     /></VALUE>
           <DEFAULT_VAL ><xsl:value-of select="@defaultVal"/></DEFAULT_VAL>
           <LBLCD       ><xsl:value-of select="@lbl"       /></LBLCD>
           <MSGCD       ><xsl:value-of select="@message"   /></MSGCD>
           <MUST        ><xsl:value-of select="@must"      /></MUST>
           <VIEW_LENGTH ><xsl:value-of select="substring(@size,1,10)" /></VIEW_LENGTH>
           <USE_LENGTH  ><xsl:value-of select="@maxlength" /></USE_LENGTH>
           <CODE_CLM    ><xsl:value-of select="@codeName"  /></CODE_CLM>
           <READONLY    ><xsl:value-of select="@readonly"  /></READONLY>
           <DISABLED    ><xsl:value-of select="@disabled"  /></DISABLED>
           <ROLES       ><xsl:value-of select="@roles"     /></ROLES>
           <TEXT_DATA    ><xsl:copy-of select="."           /></TEXT_DATA>
         </ROW>
    </xsl:if>
  </xsl:template>
  

</xsl:stylesheet>
