package org.opengion.hayabusa.io;

import javax.servlet.http.HttpSession;

import org.opengion.hayabusa.common.HybsSystemException;

/**
 * クラウド別のクラス生成
 * 
 * @og.rev 5.9.25.0 (2017/10/06) 新規作成
 * @og.group
 *
 * @version 5.0
 * @author T.OTA
 * @sinse JDK7.0
 */
public class StorageAPIFactory {
	/**
	 * デフォルトコンストラクタを private 化しておきます。
	 */
	private StorageAPIFactory(){};

	/**
	 * 指定されたクラウド対象クラスを生成する
	 *
	 * @param storage クラウド種別
	 * @param container コンテナ
	 * @param hsession セッション
	 * @return StorageAPIを継承したクラス
	 */
	public static StorageAPI newStorageAPI(String storage, String container, HttpSession hsession){
		StorageAPI storageapi;
		try{
			// StorageAPIの実装ｸﾗｽをstorage別に生成する
			Object[] args = new Object[]{container, hsession};
			storageapi = (StorageAPI)Class.forName( "org.opengion.plugin.cloud.StorageAPI_" + storage )
					.getConstructor(String.class, HttpSession.class)
					.newInstance(args);
		}catch(Exception e){
			StringBuilder sbErrMsg = new StringBuilder();
			sbErrMsg.append("ｸﾗｳﾄﾞｽﾄﾚｰｼﾞ用のｸﾗｽ生成に失敗しました。storage:");
			sbErrMsg.append(storage);
			sbErrMsg.append(" container:");
			sbErrMsg.append(container);
			sbErrMsg.append(" errInfo:");
			sbErrMsg.append(e);
			sbErrMsg.append(" errCause:");
			sbErrMsg.append(e.getCause());
			throw new HybsSystemException(sbErrMsg.toString());
		}
		return storageapi;
	}
}
