<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:mis="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java mis" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <ADDRESS   ><xsl:value-of select="$ADDRESS"   /></ADDRESS>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
  </xsl:param>

  <xsl:template match="jsp:root">
    <xsl:apply-templates select="//mis:query | //mis:update | //mis:plsqlUpdate" />
    <xsl:apply-templates select="//mis:value[@command='SQL'] | //mis:userInfo[@command='SQL']" />
  </xsl:template>

  <xsl:template match="mis:query | mis:update | mis:plsqlUpdate">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <NAMES     ><xsl:value-of select="@names"     /></NAMES>
       <TABLEID   ><xsl:value-of select="@tableId"   /></TABLEID>
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <QUERYTYPE ><xsl:value-of select="@queryType" /></QUERYTYPE>
       <SCOPE     ><xsl:value-of select="@scope"     /></SCOPE>
       <QUERY     ><xsl:copy-of select="*"           /></QUERY>
     </ROW>
  </xsl:template>

  <xsl:template match="mis:value[@command='SQL'] | mis:userInfo[@command='SQL']">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <NAMES     ><xsl:value-of select="@names"     /></NAMES>
       <TABLEID   />
       <DBID      />
       <QUERYTYPE />
       <SCOPE     />
       <QUERY     ><xsl:copy-of select="*"           /></QUERY>
     </ROW>
  </xsl:template>

</xsl:stylesheet>
