/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.util.HashMap;
import java.util.Map;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.FirstProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.queue.QueueInfo;
import org.opengion.fukurou.queue.QueueSend;
import org.opengion.fukurou.queue.QueueSendFactory;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.LogWriter;

public class Process_QueueSend
extends AbstractProcess
implements FirstProcess {
    private static final String name = "";
    private static final Map<String, String> mustProperty = new HashMap<String, String>();
    private static final Map<String, String> usableProperty;
    QueueSend queueSend;
    private String queueType;
    private String jmsServer;
    private String groupId;
    private String message;

    public Process_QueueSend() {
        super(name, mustProperty, usableProperty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.queueType = argument.getProparty("queueType");
        this.jmsServer = argument.getProparty("jmsServer");
        this.groupId = argument.getProparty("groupId");
        this.message = argument.getProparty("message");
        String string = argument.getProparty("accessKey");
        String string2 = argument.getProparty("secretKey");
        this.queueSend = QueueSendFactory.newQueueSend(this.queueType);
        this.queueSend.setBatchFlg(true);
        this.queueSend.connect(this.jmsServer, string, string2);
    }

    @Override
    public void end(boolean bl) {
        this.queueType = name;
        this.jmsServer = name;
        this.groupId = name;
        this.message = name;
        if (this.queueSend != null) {
            this.queueSend.close();
        }
        this.queueSend = null;
    }

    @Override
    public boolean next() {
        QueueInfo queueInfo = new QueueInfo();
        queueInfo.setJmsServer(this.jmsServer);
        queueInfo.setMqQueueName(this.groupId);
        queueInfo.setSqsFifoGroupId(this.groupId);
        queueInfo.setMessage(this.message);
        this.queueSend.sendMessage(queueInfo);
        return false;
    }

    @Override
    public LineModel makeLineModel(int n) {
        return null;
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + "\t" + "queueType:" + this.queueType + CR + "\t" + "jmsServer:" + this.jmsServer + CR + "\t" + "gropuId:" + this.groupId + CR + "\t" + "message:" + this.message;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Process_QueueSend\u306f\u3001MQ or SQS\u306b\u30e1\u30c3\u30bb\u30fc\u30b8\u30ad\u30e5\u30fc\u3092\u9001\u4fe1\u3059\u308b\u3001").append(CR);
        stringBuilder.append("FirstProcess\u30a4\u30f3\u30bf\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("-queueType=\u30ad\u30e5\u30fc\u30bf\u30a4\u30d7   :MQ or SQS").append(CR);
        stringBuilder.append("-jmsServer=\u30ad\u30e5\u30fc\u30b5\u30fc\u30d0\u30fc :\u30ad\u30e5\u30fc\u30b5\u30fc\u30d0\u30fc\u306eURL\u3092\u6307\u5b9a").append(CR);
        stringBuilder.append("-groupId=\u30b0\u30eb\u30fc\u30d7ID       :\u30ad\u30e5\u30fc\u683c\u7d0d\u5148\u306e\u30b0\u30eb\u30fc\u30d7ID").append(CR);
        stringBuilder.append("-message=\u9001\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8   :\u30ad\u30e5\u30fc\u306b\u683c\u7d0d\u3059\u308b\u30e1\u30c3\u30bb\u30fc\u30b8").append(CR);
        stringBuilder.append("[-sccessKey=\u30a2\u30af\u30bb\u30b9\u30ad\u30fc]").append(CR);
        stringBuilder.append("[-secretKey=\u30b7\u30fc\u30af\u30ec\u30c3\u30c8\u30ad\u30fc]").append(CR);
        stringBuilder.append(CR).append(CR);
        stringBuilder.append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_QueueSend().usage());
    }

    static {
        mustProperty.put("queueType", "\u30ad\u30e5\u30fc\u30bf\u30a4\u30d7");
        mustProperty.put("jmsServer", "jms\u63a5\u7d9a\u5148");
        mustProperty.put("groupId", "\u30b0\u30eb\u30fc\u30d7ID");
        mustProperty.put("message", "\u30e1\u30c3\u30bb\u30fc\u30b8");
        usableProperty = new HashMap<String, String>();
        usableProperty.put("accessKey", "\u30a2\u30af\u30bb\u30b9\u30ad");
        usableProperty.put("secretKey", "\u30b7\u30fc\u30af\u30ec\u30c3\u30c8\u30ad\u30fc");
    }
}

