/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.auth;

import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.PropertiesCredentials;
import com.ibm.cloud.objectstorage.oauth.DefaultTokenManager;
import com.ibm.cloud.objectstorage.oauth.TokenManager;
import java.io.File;
import java.io.IOException;

public class PropertiesFileCredentialsProvider
implements AWSCredentialsProvider {
    private final String credentialsFilePath;
    private TokenManager tokenManager = null;

    public PropertiesFileCredentialsProvider(String credentialsFilePath) {
        if (credentialsFilePath == null) {
            throw new IllegalArgumentException("Credentials file path cannot be null");
        }
        this.credentialsFilePath = credentialsFilePath;
    }

    @Override
    public AWSCredentials getCredentials() {
        try {
            PropertiesCredentials credentials = new PropertiesCredentials(new File(this.credentialsFilePath));
            if (credentials.getApiKey() != null && this.tokenManager == null) {
                this.tokenManager = new DefaultTokenManager(credentials.getApiKey());
            }
            credentials.setTokenManager(this.tokenManager);
            return credentials;
        }
        catch (IOException e) {
            throw new SdkClientException("Unable to load AWS credentials from the " + this.credentialsFilePath + " file", e);
        }
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.credentialsFilePath + ")";
    }
}

