/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.dns.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.List;
import org.openstack4j.model.dns.v2.Nameserver;
import org.openstack4j.model.dns.v2.builder.NameserverBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DesignateNameserver
implements Nameserver {
    private static final long serialVersionUID = 1L;
    private String hostname;
    private Integer priority;

    public static NameserverBuilder builder() {
        return new NameserverConcreteBuilder();
    }

    @Override
    public NameserverBuilder toBuilder() {
        return new NameserverConcreteBuilder(this);
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("hostname", (Object)this.hostname).add("priority", (Object)this.priority).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hostname, this.priority});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DesignateNameserver that = (DesignateNameserver)DesignateNameserver.class.cast(obj);
        return Objects.equal((Object)this.hostname, (Object)that.hostname) && Objects.equal((Object)this.priority, (Object)that.priority);
    }

    public static class Nameservers
    extends ListResult<DesignateNameserver> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="nameservers")
        protected List<DesignateNameserver> list;

        @Override
        public List<DesignateNameserver> value() {
            return this.list;
        }
    }

    public static class NameserverConcreteBuilder
    implements NameserverBuilder {
        DesignateNameserver model;

        NameserverConcreteBuilder() {
            this(new DesignateNameserver());
        }

        NameserverConcreteBuilder(DesignateNameserver model) {
            this.model = model;
        }

        @Override
        public Nameserver build() {
            return this.model;
        }

        @Override
        public NameserverBuilder from(Nameserver in) {
            if (in != null) {
                this.model = (DesignateNameserver)in;
            }
            return this;
        }

        @Override
        public NameserverBuilder hostname(String hostname) {
            this.model.hostname = hostname;
            return this;
        }

        @Override
        public NameserverBuilder priority(Integer priority) {
            this.model.priority = priority;
            return this;
        }
    }
}

