<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP03"
	title    = "レイアウトテーブル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- 入力チェックを行います。 -->
<!-- 入力内容がNULLの場合にエラーを返したい場合は、nullCheck属性を追加して下さい。-->
<og:columnCheck command="{@command}" />

<!-- forward.jsp から command="ENTRY" がセットされて遷移してくるので、DB登録画面となります。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" />

<og:value command="SETTBL" key="LISTID" separator="','" action="APPEND"/>

<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
<!-- 通常は変更する必要はありません。 -->
<og:transaction>
	<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}">
		<og:tableUpdateParam
			sqlType		= "{@sqlType}"
			table		= "GE52"
			where		= "SYSTEM_ID=[SYSTEM_ID] AND LISTID=[LISTID] AND KBTEXT=[KBTEXT] AND CLM=[CLM]"
			omitNames	= "NAME_JA,SYSID"
		/>
	</og:tableUpdate>
</og:transaction>

<og:query
	command		= "RENEW"
	quotCheck	= "false">
		SELECT SYSTEM_ID,LISTID,KBTEXT,CLM,SEQ,USE_LENGTH,START_POS
		FROM GE52
		WHERE FGJ = '1'
		AND LISTID IN ('{@LISTID}')
		ORDER BY SYSTEM_ID,LISTID,KBTEXT,SEQ
</og:query>
<og:tableFilter classId="REPORTLAYOUT" selectedAll="true" />
<og:tableUpdate
	command		= "{@command}"
	selectedAll = "true"
	queryType	= "JDBCTableUpdate">
		UPDATE GE52 SET
			SEQ = [SEQ]
			,START_POS = [START_POS]
		WHERE SYSTEM_ID = [SYSTEM_ID]
		AND LISTID = [LISTID]
		AND KBTEXT = [KBTEXT]
		AND CLM    = [CLM]
</og:tableUpdate>

<og:value command="REMOVE" key="LISTID" />

<!-- 変更はここまでです。 -->

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
